% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/recommender_uRegression.R
\name{predict.u_regression}
\alias{predict.u_regression}
\title{Recommend models for new datasets using uRegression}
\usage{
predict.u_regression(object, test_metafeatures, score = F)
}
\arguments{
\item{object}{Object obtained from `uregression_rf_fit()`.}

\item{test_metafeatures}{A a data frame containing the metafeatures of each dataset as columns.}
}
\value{
A character string corresponding to the recommended model per row on `test_metafeatures`.
}
\description{
Model recommendation. Issues a single model recommendation per row in `test_metafeatures`.
}
\examples{

dat <- get_data()
ureg <- recommender('u_regression_rf')
ureg <- ureg \%>\% fit(dat$train$performance, dat$train$metafeatures, 5, nrounds = 20)
ureg \%>\% predict(dat$test$metafeatures)
}
