% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/recommender_global_best.R
\name{fit.global_best}
\alias{fit.global_best}
\title{Fit Global Best model recommender}
\usage{
fit.global_best(
  object,
  train_performance,
  train_metafeatures = NULL,
  median = T,
  ...
)
}
\arguments{
\item{train_performance}{A data frame or matrix corresponding one row per dataset and one column per configuration, with performance values on each cell.}

\item{train_metafeatures}{A a data frame containing the metafeatures of each dataset as columns.}

\item{median}{Logical. Whether to use median (`TRUE`) or mean (`FALSE`) to select a model. Defaults to `TRUE`.}
}
\value{
A list containing one element: `recommendation`, the selected configuration.
}
\description{
Baseline recommender: selects the configuration with best mean / median out of all and always recommends it.
}
\examples{

dat <- get_sample_data(train_test_split = T)
gb <- recommender('global_best')
gb <- gb \%>\% fit(dat$train$performance, dat$train$metafeatures, median = T)
gb \%>\% predict(dat$test$metafeatures)
}
