% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/recommender_orthus.R
\name{fit.orthus}
\alias{fit.orthus}
\title{Fit Orthus model recommender}
\usage{
fit.orthus(object, train_performance, train_metafeatures, ...)
}
\arguments{
\item{train_performance}{A data frame or matrix corresponding one row per dataset and one column per configuration, with performance values on each cell.}

\item{train_metafeatures}{A a data frame containing the metafeatures of each dataset as columns.}
}
\value{
A list of class `Orthus` containing four elements: `local_head`, a fitted cFact recommender, `global_head`, a fitted URegression recommender, `train_metafeatures`, the
internal data frame used to calculate new datasets distances, and `recommender_type`, a character containing the recommender type ('Orthus').
}
\description{
Bi-headed model that uses UMAP and clustering to detect if new datasets to output recommendations to are close or far from existing datasets in the
meta-feature space. It uses a URegression model for novel datasets and a cFact recommender for existing datasets.
}
\examples{

dat <- get_sample_data(train_test_split = T)
orthus <- recommender('orthus')
orthus <- orthus \%>\% fit(dat$train$performance, dat$train$metafeatures)
orthus \%>\% predict(dat$test$metafeatures)
}
