% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_precomputed_metafeatures.R
\name{get_precomputed_metafeatures}
\alias{get_precomputed_metafeatures}
\title{Get Precomputed Metafeatures}
\usage{
get_precomputed_metafeatures(
  providers = "all",
  include_metaod = T,
  include_c22 = T,
  sanitize = T,
  scale = T
)
}
\arguments{
\item{providers}{`all` or any combination of `BGP`, `Benchmark`, `SMD` and `Water`. Defaults to `all`.}

\item{include_metaod}{Logical. Add metaod metafeatures. Defaults to `TRUE`.}

\item{include_c22}{Logical. Add catch22 metafeatures. Defaults to `TRUE`.}

\item{sanitize}{Logical. Sanitize the metafeatures, discarding high moments and correcting missing / infinite values to appropriate ones. Defaults to `TRUE`.}

\item{scale}{Logical. Transform the metafeatures to same units, rescaling them to 0-1. Defaults to `TRUE`.}
}
\value{
Data frame with columns `provider`, `instance`, `node` and the selected metafeatures associated with that row's dataset.
}
\description{
Get a data frame of precomputed metafeatures for almost any of the data providers we use. The code to generate them is in
`data-raw/generate_metafeatures_cache.R`.
}
