% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/recommender_global_best.R
\name{predict.global_best}
\alias{predict.global_best}
\title{Recommend models for new datasets using globalbest}
\usage{
predict.global_best(object, test_metafeatures)
}
\arguments{
\item{object}{Object obtained from `globalbest_fit()`.}

\item{test_metafeatures}{A a data frame containing the metafeatures of each dataset as columns.}
}
\value{
A character string corresponding to the recommended model per row on `test_metafeatures`.
}
\description{
Model recommendation. Issues a single model recommendation per row in `test_metafeatures`.
}
\examples{

dat <- get_sample_data(train_test_split = T)
gb <- recommender('global_best')
gb <- gb \%>\% fit(dat$train$performance, dat$train$metafeatures, median = T)
gb \%>\% predict(dat$test$metafeatures)
}
