% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/recommender_regression.R
\name{predict.regression}
\alias{predict.regression}
\title{Recommend models for new datasets using regression}
\usage{
predict.regression(object, test_metafeatures, score = F)
}
\arguments{
\item{object}{Object obtained from `fit.regression_rf()`.}

\item{test_metafeatures}{A a data frame containing the metafeatures of each dataset as columns.}
}
\value{
A character string corresponding to the recommended model per row on `test_metafeatures`.
}
\description{
Model recommendation. Issues a single model recommendation per row in `test_metafeatures`.
}
\examples{

dat <- get_sample_data()
reg <- recommender('regression_rf')
reg <- reg \%>\% fit(dat$train$performance, dat$train$metafeatures, 5, nrounds = 20)
reg \%>\% predict(dat$test$metafeatures)
}
