import matplotlib.pyplot as plt

replace_json = {
  "a": "@", "b": "♭", "c": "⊂", "d": "∂", "e": "ϵ", "f": "ƒ", "g": "ɡ",
  "h": "ħ", "i": "ι", "j": "⅃", "k": "ƙ", "l": "∥", "m": "ϻ", "n": "∩",
  "o": "○", "p": "ρ", "q": "ʠ", "r": "ɼ", "s": "∫", "t": "⊤", "u": "μ",
  "v": "∨", "w": "ω", "x": "×", "y": "Υ", "z": "ζ"
}

# 准备数据
letters = list(replace_json.keys())
symbols = [replace_json[k] for k in letters]
codepoints = [f"U+{ord(replace_json[k]):04X}" for k in letters]

# 生成表格数据（分成三列: Letter, Symbol, Codepoint）
data = list(zip(letters, symbols, codepoints))

# 绘制表格
fig, ax = plt.subplots(figsize=(6, 10))  # 宽高可以根据需求调整
ax.axis("off")  # 不显示坐标轴

# 列标签
columns = ["Letter", "Symbol", "Unicode"]

# 生成表格
table = ax.table(cellText=data, colLabels=columns, loc="center", cellLoc="center")

# 调整表格样式
table.auto_set_font_size(False)
table.set_fontsize(12)
table.scale(1.2, 1.2)

# 保存为PNG（也可以保存为pdf/svg）
# plt.savefig("mapping_table.png", dpi=300, bbox_inches="tight")
plt.savefig("/home/wind/Desktop/新工作/2024_8_18/figures/iclr/mapping_table.pdf", bbox_inches="tight")  # 如果需要矢量图
plt.show()
