import argparse
import re

def process_file(filename, prefix, number):
    # 读入所有行
    with open(filename, "r", encoding="utf-8") as f:
        lines = f.readlines()

    # 遍历每3行
    for i in range(0, len(lines), 3):
        if i + 2 >= len(lines):  # 避免越界
            break

        first_line = lines[i].strip()
        second_line = lines[i+1].strip()

        # 检查 prefix 是否匹配
        if first_line.startswith(prefix):
            # 提取 prefix 后面的数字
            match = re.search(rf"^{re.escape(prefix)}(\d+)", first_line)
            if match:
                value = int(match.group(1))
                if value >= number:
                    # 修改第二行中的 success rate 为 0
                    lines[i+1] = re.sub(r"(jailbreak success rate:\s*)([\d.]+%)",
                                        r"\g<1>0%", second_line + "\n")

    # 写回文件（覆盖）
    with open(filename, "w", encoding="utf-8") as f:
        f.writelines(lines)


if __name__ == "__main__":
    parser = argparse.ArgumentParser()
    parser.add_argument("--filename", help="输入文件路径")
    parser.add_argument("--prefix", required=True, help="匹配的前缀")
    parser.add_argument("--number", type=int, required=True, help="阈值")
    args = parser.parse_args()

    process_file(args.filename, args.prefix, args.number)
