import random
from encode import *
from decode import *
'''
Word encoder
'''
class Coder():

    def __init__(self) -> None:
        # self.encoder = encode_dict
        self.target_encode_language = []
        self.target_decode_language = []
        self.encode_method_dict = {}
        self.decode_method_dict = {}

        # 接下来装载encode, decode方法
        self.encode_add(Ubbi_Dubbi_encode, "ubbi dubbi", "en")
        self.decode_add(Ubbi_Dubbi_decode, "ubbi dubbi", "en")
        self.encode_add(leet_speak_encode, "leet speak", "en")
        self.decode_add(leet_speak_decode, "leet speak", "en")
        self.encode_add(atbash_cipher_encode, "atbash cipher", "en")
        self.decode_add(atbash_cipher_decode, "atbash cipher", "en")
        self.encode_add(backslang_encode, "backslang", "en")
        self.decode_add(backslang_decode, "backslang", "en")
        self.encode_add(pig_latin_encode_sentence, "pig latin", "en")
        self.decode_add(pig_latin_decode_sentence, "pig latin", "en")
        self.encode_add(verlan_encode, "verlan", "fr")
        self.decode_add(verlan_decode, "verlan", "fr")
        self.encode_add(encode_loeffelsprache, "loeffelsprache", "ge")
        self.decode_add(decode_loeffelsprache, "loeffelsprache", "ge")
        self.encode_add(aigy_paigy_encode, "aigy paigy", "en")
        self.decode_add(aigy_paigy_decode, "aigy paigy", "en")
        self.encode_add(alfa_balfa_encode, "alfa balfa", "en")
        self.decode_add(alfa_balfa_decode, "alfa balfa", "en")
        self.encode_add(self0_encode, "self0", "en")
        self.decode_add(self0_decode, "self0", "en")
        self.encode_add(self1_encode, "self1", "en")
        self.decode_add(self1_decode, "self1", "en")
        self.encode_add(self9_encode, "self9", "en")
        self.decode_add(self9_decode, "self9", "en")
        self.decode_add(self8_decode, "self8", "en")
        self.encode_add(self8_encode, "self8", "en")
        self.encode_add(self7_encode, "self7", "en")
        self.decode_add(self7_decode, "self7", "en")
        self.encode_add(self6_encode, "self6", "en")
        self.decode_add(self6_decode, "self6", "en")
        self.encode_add(self5_encode, "self5", "en")
        self.decode_add(self5_decode, "self5", "en")
        self.encode_add(self4_encode, "self4", "en")
        self.decode_add(self4_decode, "self4", "en")
        self.encode_add(self3_encode, "self3", "en")
        self.decode_add(self3_decode, "self3", "en")
        self.encode_add(self2_encode, "self2", "en")
        self.decode_add(self2_decode, "self2", "en")
        self.encode_add(self10_encode, "self10", "en")
        self.decode_add(self10_decode, "self10", "en")

        self.encode_add(llama8b_encode, "llama8b", "en")
        self.encode_add(llama70b_encode, "llama70b", "en")
        self.encode_add(qwen72b_encode, "qwen72b", "en")
        self.encode_add(qwen32b_encode, "qwen32b", "en")
        self.encode_add(qwen14b_encode, "qwen14b", "en")
        self.encode_add(qwen7b_encode, "qwen7b", "en")

        self.decode_add(llama8b_decode, "llama8b", "en")
        self.decode_add(llama70b_decode, "llama70b", "en")
        self.decode_add(qwen72b_decode, "qwen72b", "en")
        self.decode_add(qwen32b_decode, "qwen32b", "en")
        self.decode_add(qwen14b_decode, "qwen14b", "en")
        self.decode_add(qwen7b_decode, "qwen7b", "en")

        self.encode_add(claude_encode, "claude", "en")
        self.encode_add(gpt4o_encode, "gpt4o", "en")
        self.encode_add(gpt4omini_encode, "gpt4omini", "en")

        self.decode_add(claude_decode, "claude", "en")
        self.decode_add(gpt4o_decode, "gpt4o", "en")
        self.decode_add(gpt4omini_decode, "gpt4omini", "en")

        self.encode_add(claude4_encode, "claude4", "en")
        self.encode_add(gpt5_encode, "gpt5", "en")

        self.decode_add(claude4_decode, "claude4", "en")
        self.decode_add(gpt5_decode, "gpt5", "en")
    '''
    encode_method: {
        type: Function,
        description: The function to encode.
        example: 
    }
    method_name: {
        type: str,
        description: name of the method,
        exmaple, "leet speak"
    }
    target: {
        type: str,
        description: The target language,
        exmaple: en, zh
    }
    Notice: our method should not include any uppercase letters.
    '''
    def encode_add(self, encode_method, method_name,target="en"):
        if target not in self.target_encode_language:
            self.target_encode_language.append(target) 
            self.encode_method_dict[target] = {method_name:encode_method}
        else:
            self.encode_method_dict[target][method_name] = encode_method
    '''
    decode_method: {
        type: Function,
        description: The function to encode.
        example: 
    }
    method_name: {
        type: str,
        description: name of the method,
        exmaple, "leet speak"
    }
    target: {
        type: str,
        description: The target language,
        exmaple: en, zh
    }
    Notice: our method should not include any uppercase letters.
    '''
    def decode_add(self, decode_method, method_name,target):
        if target not in self.target_decode_language:
            self.target_decode_language.append(target) 
            self.decode_method_dict[target] = {method_name:decode_method}
        else:
            self.decode_method_dict[target][method_name] = decode_method
    '''
    text: {
        type = str,
        description: The text waited to be encoded
    }
    target: {
        type: str,
        description: The target language,
        exmaple: en, zh
    }
    method_name: {
        type: str,
        description: name of the method,
        exmaple, "leet speak"
    }
    '''
    def encode(self, text ,target, method_name = None):
        text = text.lower()
        if target not in self.target_encode_language:
            raise Exception("Target is not in target language")
        if method_name != None and method_name in self.encode_method_dict[target]:
            encoding_method = self.encode_method_dict[target][method_name]
        else:
            collection_method_list = [method for method, func in self.encode_method_dict[target].items()] 
            random_index = random.randint(0, len(collection_method_list) - 1)
            choosed_method_name = collection_method_list[random_index]
            encoding_method = self.encode_method_dict[target][choosed_method_name]
        
        return encoding_method(text)
    '''
    text: {
        type = str,
        description: The text waited to be decoded
    }
    target: {
        type: str,
        description: The target language,
        exmaple: en, zh
    }
    method_name: {
        type: str,
        description: name of the method,
        exmaple, "leet speak"
    }
    '''
    def decode(self, text ,target, method_name = None):
        text = text.lower()
        if target not in self.target_decode_language:
            raise Exception("Target is not in target language")
        if method_name != None and method_name in self.decode_method_dict[target]:
            decoding_method = self.decode_method_dict[target][method_name]
        else:
            collection_method_list = [method for method, func in self.decode_method_dict[target].items()] 
            random_index = random.randint(0, len(collection_method_list) - 1)
            choosed_method_name = collection_method_list[random_index]
            decoding_method = self.decode_method_dict[target][choosed_method_name]
        
        return decoding_method(text)
    
    '''
    获得编码为目标语言保存的方法
    target:{
        type: str
        description: 编码的目标语言
        example: en, zh
    }
    '''
    def get_target_encode_method(self, target):
        if target not in self.target_encode_language:
            return []
        else:
            return [method for method, func in self.encode_method_dict[target].items()] 


    '''
    获得解码目标语言保存的方法
    target:{
        type: str
        description: 解码目标语言
        example: en, zh
    }
    '''
    def get_target_decode_method(self, target):
        if target not in self.target_decode_language:
            return []
        else:
            return [method for method, func in self.decode_method_dict[target].items()] 
