# 这个文件是比较合并之后的文件与base文件是否一致的结构而创立
# base文件为base.json
import json
import argparse

def load_json(filename):
    with open(filename, 'r', encoding='utf-8') as f:
        return json.load(f)

def compare_or_questions(base_data, compare_data):
    if not (isinstance(base_data, list) and isinstance(compare_data, list)):
        print("❌ 错误：文件结构不是顶层列表。")
        return

    if len(base_data) != 3 or len(compare_data) != 3:
        print("❌ 错误：每个文件应包含三个列表。")
        return

    all_match = True

    for i in range(3):
        base_list = base_data[i]
        compare_list = compare_data[i]

        if len(base_list) != len(compare_list):
            print(f"❌ 第 {i+1} 个子列表长度不同：base={len(base_list)}，compare={len(compare_list)}")
            all_match = False
            continue

        for j, (b_item, c_item) in enumerate(zip(base_list, compare_list)):
            b_q = b_item.get('or_question')
            c_q = c_item.get('or_question')

            if b_q != c_q:
                print(f"❌ 不匹配：第 {i+1} 组 第 {j+1} 项")
                print(f"    base   : {b_q}")
                print(f"    compare: {c_q}")
                all_match = False

    if all_match:
        print("✅ 所有 or_question 完全一致。")
    else:
        print("🔍 存在 or_question 不一致项。")

if __name__ == "__main__":
    parser = argparse.ArgumentParser(description="比较两个结构一致的 JSON 文件中 or_question 字段是否一致")
    parser.add_argument("--basefile", required=True, help="基准 JSON 文件")
    parser.add_argument("--compare_file", required=True, help="要比较的 JSON 文件")
    args = parser.parse_args()

    base_data = load_json(args.basefile)
    compare_data = load_json(args.compare_file)

    compare_or_questions(base_data, compare_data)
