import inspect
import os

def my_log(text):
    # 获取当前调用栈中的前一帧（即调用 log() 的函数）
    frame = inspect.currentframe().f_back

    # 获取函数名
    func_name = frame.f_code.co_name

    # 获取文件名（只取文件名，不包含路径）
    file_name = os.path.basename(frame.f_code.co_filename)

    print(f"[{file_name}::{func_name}] {text}")
