import json
import argparse
import os

def split_long_list(filename):
    with open(filename, 'r', encoding='utf-8') as f:
        data = json.load(f)

    if not isinstance(data, list):
        print("❌ 错误：文件内容不是列表。")
        return

    length = len(data)
    chunk_size = length // 3
    base_name = os.path.splitext(filename)[0]

    for i in range(3):
        start = i * chunk_size
        end = (i + 1) * chunk_size if i < 2 else length  # 最后一段包含剩余
        chunk = data[start:end]
        output_filename = f"{base_name}_part{i+1}.json"
        with open(output_filename, 'w', encoding='utf-8') as out_f:
            json.dump(chunk, out_f, ensure_ascii=False, indent=2)
        print(f"✅ 拆分保存：{output_filename}")

def combine_lists(file_list_str):
    file_list = file_list_str.split(',')
    combined = []

    for file in file_list:
        file = file.strip()
        with open(file, 'r', encoding='utf-8') as f:
            data = json.load(f)
            if isinstance(data, list):
                combined.extend(data)
                print(f"✅ 合并文件：{file}，长度：{len(data)}")
            else:
                print(f"⚠️ 警告：文件 {file} 内容不是列表，已跳过。")

    output_filename = "combined_output.json"
    with open(output_filename, 'w', encoding='utf-8') as out_f:
        json.dump(combined, out_f, ensure_ascii=False, indent=2)
    print(f"✅ 合并保存：{output_filename}")
    print(f"✅ 长度为:{len(combined)}")
    # print(combined[5])

if __name__ == "__main__":
    parser = argparse.ArgumentParser(description="拆分或合并 JSON 列表文件")
    parser.add_argument("--file", required=True, help="输入文件名（单个文件或多个文件，用英文逗号分隔）")
    parser.add_argument("--split", type=int, choices=[0, 1], default=0, help="是否进行拆分（1=拆分）")
    parser.add_argument("--combine", type=int, choices=[0, 1], default=0, help="是否进行合并（1=合并）")

    args = parser.parse_args()

    if args.split:
        split_long_list(args.file)
    elif args.combine:
        combine_lists(args.file)
    else:
        print("❗ 错误：请指定 --split 1 或 --combine 1 中的一个。")
