import json
import argparse
import os

def split_nested_list(input_filename):
    with open(input_filename, 'r', encoding='utf-8') as f:
        data = json.load(f)

    if isinstance(data, list) and len(data) == 3 and all(isinstance(item, list) for item in data):
        base_name = os.path.splitext(input_filename)[0]
        for i, sublist in enumerate(data):
            output_filename = f"{base_name}_part{i+1}.json"
            with open(output_filename, 'w', encoding='utf-8') as out_f:
                json.dump(sublist, out_f, ensure_ascii=False, indent=2)
            print(f"✅ 拆分保存：{output_filename}")
    else:
        print("❌ 错误：JSON 内容不是包含三个子列表的列表。")

def combine_lists_to_nested(file_list_str):
    file_list = file_list_str.split(',')
    nested = []

    for file in file_list:
        file = file.strip()
        with open(file, 'r', encoding='utf-8') as f:
            data = json.load(f)
            if isinstance(data, list):
                nested.append(data)
            else:
                print(f"⚠️ 警告：文件 {file} 不是列表，已跳过")

    output_filename = "combined_nested.json"
    with open(output_filename, 'w', encoding='utf-8') as out_f:
        json.dump(nested, out_f, ensure_ascii=False, indent=2)
    print(f"✅ 合并保存：{output_filename}")

if __name__ == "__main__":
    parser = argparse.ArgumentParser(description="拆分或组合 JSON 文件")
    parser.add_argument("--file", required=True, help="输入文件名（单个或多个，用英文逗号分隔）")
    parser.add_argument("--split", type=int, choices=[0, 1], default=0, help="是否进行拆分")
    parser.add_argument("--combine", type=int, choices=[0, 1], default=0, help="是否进行组合")
    args = parser.parse_args()

    if args.split == 1 and args.combine == 0:
        split_nested_list(args.file)
    elif args.split == 0 and args.combine == 1:
        combine_lists_to_nested(args.file)
    else:
        print("❌ 请指定一个明确的操作：--split 1 或 --combine 1（只能选一个）")
