import matplotlib.pyplot as plt
import numpy as np

# Example data (replace with your own)
x_labels = ["5", "15", "25", "35", "50", "100", "200", "1000"]
x_positions = [0, 0.8, 1.6, 2.4, 3.5, 5, 7, 10]

means = {
    "VP": [0.28988, 0.34276, 0.3535, 0.35818, 0.36204, 0.36684, 0.36966, 0.37278],
    "IS": [0.19546, 0.32498, 0.35474, 0.36902, 0.37962, 0.39574, 0.40014, 0.41514],
    "SMC": [0.2913, 0.37724, 0.3963, 0.40528, 0.41206, 0.42076, 0.42582, 0.42836]
}

stds = {
    "VP": [0.01225, 0.00931, 0.00866, 0.00845, 0.00833, 0.00798, 0.00789, 0.00760],
    "IS": [0.02975, 0.01181, 0.00934, 0.00999, 0.01080, 0.01450, 0.00855, 0.00475],
    "SMC": [0.01212, 0.00906, 0.00847, 0.00808, 0.00786, 0.00780, 0.00786, 0.00827]
}

colors = {'VP': '#1f77b4', 'IS': '#ff7f0e', 'SMC': '#2ca02c'}
markers = {'VP': 'o', 'IS': 's', 'SMC': '^'}

plt.figure(figsize=(9, 5))
plt.rcParams["font.family"] = "serif"

# Plot each with error bars
for method in means:
    plt.errorbar(x_positions, means[method], yerr=stds[method], 
                 fmt=markers[method]+'-', color=colors[method],
                 capsize=4, label=method, linewidth=2.5, markersize=7, 
                 markerfacecolor='white', markeredgewidth=2)

# Labels and ticks
plt.xlabel('Number of Samples', fontsize=16, weight='bold')
plt.ylabel('Log Likelihood', fontsize=16, weight='bold')
plt.xticks(x_positions, x_labels, fontsize=14, weight='bold')
plt.yticks(fontsize=14, weight='bold')

# Grid and legend
plt.grid(True, linestyle=':', alpha=0.5, linewidth=1.5)
legend = plt.legend(fontsize=14, frameon=False)
for text in legend.get_texts():
    text.set_weight("bold")

# Remove top and right spines
plt.gca().spines['top'].set_visible(False)
plt.gca().spines['right'].set_visible(False)

# Optional: Fix y-axis range for consistency
plt.ylim(0.18, 0.44)

plt.tight_layout()

# Save as PDF (optional)
plt.savefig("comparison_plot.pdf", format="pdf", transparent=True)

plt.show()
