### In order to reproduce the results in the paper, please run the following commands.

### 1. Pre-training
python scripts/gp_nd.py -f configs/gp/np_tts.yaml --x_dim 1 --num_steps 100000 --lr 5e-4 --train_batch_size 32 --weight_decay 0 --train_seed 1111

### 2-1. Fine-tuning: NP
python scripts/gp_nd_tune.py -f configs/gp/np_tts.yaml -c results/gp_nd/1d/np_tts/infinite/s1111/checkpoint.pt --x_dim 1 --train_num_samples 50 --train_num_bs 1000 
--eval_freq 1000 --lr 1e-5 --num_steps 100000 --tts_test --train_seed 1111 --eval_seed 1 --train_kernel matern --eval_kernel matern

### 2-2. Fine-tuning: DANP
python scripts/gp_nd_tune.py -f configs/gp/dtanp_y.yaml -c results/gp_nds/dtanp_y/infinite/s1111/checkpoint.pt --x_dim 1 --train_num_samples 50 --train_num_bs 1000 \
--eval_freq 1000 --lr 5e-4 --num_steps 100000 --tts_test --train_seed 1111 --eval_seed 1

### 3-1. TTSNP: NP
python scripts/gp_nd_tts_tune.py -f configs/gp/np_tts_lg_lv_diff_pe_pseudo.yaml --x_dim 1 --train_num_bs 1000 --lr 1e-4 --num_steps 800000 --eval_freq 5000 \
-c "results/experiment_path/checkpoint.pt" --train_num_samples 50 --threshold_rate .1 --marginal_loss --kl_loss --train_seed 1111

### 3-2. TTSNP: DANP
python scripts/gp_nd_tts_tune.py -f configs/gp/dtanp_y_tts_lg_lv_diff_pe_pseudo.yaml --x_dim 1 --train_num_bs 1000 --lr 1e-4 --num_steps 100000 --eval_freq 5000 \
-c "results/experiment_path/checkpoint.pt" --train_num_samples 50 --threshold_rate .1 --kl_loss --marginal_loss --train_seed 1111


### Above scripts will produce checkpoint.pt inside the destination folder. 
### Then, run the following test code in order to reproduce the test results.

python scripts/gp_nd_tts_test.py -f configs/gp/np_tts.yaml -c results/gp_nd/1d/np_tts/infinite/s${seed}/checkpoint.pt \
--x_dim 1 --eval_num_batches 3000 --threshold_rate .1 --eval_seed 0
