# LLM4Review — Supplementary (Code + Intermediate Outputs)

This package contains code and intermediate outputs for reproducing our autonomous multi-agent workflow (Author → Reviewers → Reviser → Meta-Reviewer).

## Contents
- `src/llm4review/` — pipeline, LLM interface (stub + API), sanitization, metrics, provenance.
- `prompts/` — Author/Reviewer/Reviser/Meta prompts.
- `configs/` — thresholds, weights, budgets.
- `topics/` — 3 example topics.
- `run.sh` — offline deterministic stub (no API key).
- `run_openai.sh` — OpenAI API mode (set `OPENAI_API_KEY`).
- `scripts/` — compute metrics and export LaTeX tables.
- `statements/` — Reproducibility/Autonomy/Responsible AI statements (LaTeX).

## Quick start (offline, stub LLM)
```bash
pip install -r requirements.txt
bash run.sh
python scripts/compute_metrics.py --artifacts artifacts --out analysis
python scripts/make_tables.py --out analysis/tables
```

## Use a real LLM via API (optional)
```bash
pip install -r requirements.txt
export OPENAI_API_KEY=sk-...         # do NOT include keys in the zip
export LLM4R_MODE=openai
export LLM4R_MODEL=gpt-4o-mini       # or another chat-capable model id
bash run_openai.sh
```
Provenance is written to `artifacts/manifest.jsonl`:
`{model_family, model_version, temperature, seed, prompt_hash, redaction_hash}`.
