#!/usr/bin/env bash
set -euo pipefail
: "${OPENAI_API_KEY:?Set OPENAI_API_KEY first}"

export LLM4R_MODE=openai
export LLM4R_MODEL=${LLM4R_MODEL:-gpt-4o-mini}

OUT_DIR="artifacts"
mkdir -p "$OUT_DIR"

python -m llm4review.pipeline   --config configs/system.yaml   --topics topics/topics.jsonl   --out "$OUT_DIR"   --rounds 2   --reviewers 3   --cross-review off   --planner on   --seed 42
