import argparse, json, os
from llm4review.metrics import build_metrics

def main():
    ap = argparse.ArgumentParser()
    ap.add_argument("--artifacts", required=True)
    ap.add_argument("--out", required=True)
    args = ap.parse_args()
    os.makedirs(args.out, exist_ok=True)
    weights = {"clarity":0.2,"novelty":0.2,"methodology":0.2,"reproducibility":0.2,"ethics":0.2}
    metrics = build_metrics(args.artifacts, weights)
    with open(os.path.join(args.out, "metrics.json"),"w",encoding="utf-8") as f:
        json.dump(metrics, f, indent=2)
    print("Wrote analysis/metrics.json")

if __name__ == "__main__":
    main()
