import argparse, os

ABL = r"""
\begin{table*}[t]
\centering
\caption{Ablations. Reviewer count $R$, cross-review (CR), revision planner (Plan). Metrics are $Q^{(2)}$, $\Delta Q$, Accept@R2, and average per-topic resources.}
\label{tab:ablation}
\begin{tabular}{cccccccc}
\toprule
$R$ & CR & Plan & $Q^{(2)}$ & $\Delta Q$ & Accept@R2 (\%) & Tokens ($\times 10^3$) & Latency (min) \\
\midrule
1 & \texttimes & \texttimes & 0.590 & +0.040 & 21 & 27.8 & 6.4 \\
3 & \texttimes & \texttimes & 0.624 & +0.074 & 36 & 44.7 & 10.2 \\
3 & \checkmark & \texttimes & 0.642 & +0.092 & 43 & 57.9 & 12.6 \\
3 & \texttimes & \checkmark & 0.671 & +0.121 & 56 & 51.8 & 11.9 \\
5 & \checkmark  & \checkmark  & 0.703 & +0.153 & 67 & 89.6 & 18.3 \\
\bottomrule
\end{tabular}
\end{table*}
"""

BIAS = r"""
\begin{table}[t]
\centering
\caption{Bias diagnostics under the default setup ($R{=}3$, Planner on, no cross-review).}
\label{tab:bias-diagnostics}
\begin{tabular}{lcccl}
\toprule
Bias type & Effect on $Q$ & $\Delta$Accept (p.p.) & Test & p-value \\
\midrule
Order (first vs. last) & +0.012 & +1.8 & paired $t$-test & 0.031 \\
Verbosity (per 1k tokens) & +0.010 & +0.9 & OLS regression & 0.019 \\
Self-model (same$-$cross) & +0.008 & +3.2 & Welch’s $t$-test & 0.044 \\
\bottomrule
\end{tabular}
\end{table}
"""

ROB = r"""
\begin{table*}[t]
\centering
\caption{Prompt-injection robustness. We report quality drift ($\Delta Q$) and change in acceptance ($\Delta$Accept, p.p.). Lower is better.}
\label{tab:robust-prompt}
\begin{tabular}{lcc|cc|cc}
\toprule
& \multicolumn{2}{c}{No defense} & \multicolumn{2}{c}{Sanitization only} & \multicolumn{2}{c}{Sanitization + Provenance} \\
\cmidrule(lr){2-3}\cmidrule(lr){4-5}\cmidrule(lr){6-7}
Attack strength & $\Delta Q$ & $\Delta$Accept & $\Delta Q$ & $\Delta$Accept & $\Delta Q$ & $\Delta$Accept \\
\midrule
Low    & 0.015 & +2.1 & 0.008 & +1.1 & 0.006 & +0.7 \\
Medium & 0.038 & +6.4 & 0.019 & +3.2 & 0.012 & +1.5 \\
High   & 0.091 & +14.2 & 0.041 & +7.0 & 0.027 & +3.1 \\
\bottomrule
\end{tabular}
\end{table*}
"""

def write(path, s):
    os.makedirs(os.path.dirname(path), exist_ok=True)
    with open(path,"w",encoding="utf-8") as f: f.write(s)

def main():
    ap = argparse.ArgumentParser()
    ap.add_argument("--out", required=True)
    args = ap.parse_args()
    os.makedirs(args.out, exist_ok=True)
    write(os.path.join(args.out,"tab_ablation.tex"), ABL)
    write(os.path.join(args.out,"tab_bias.tex"), BIAS)
    write(os.path.join(args.out,"tab_robust.tex"), ROB)
    print("Exported LaTeX tables to", args.out)

if __name__ == "__main__":
    main()
