import json, os
from typing import Dict, Any
def write_jsonl(path: str, obj: Dict[str, Any]):
    os.makedirs(os.path.dirname(path), exist_ok=True)
    with open(path, "a", encoding="utf-8") as f:
        f.write(json.dumps(obj, ensure_ascii=False) + "\n")
def count_tokens(text: str) -> int:
    return max(1, len(text.strip().split()))
