import hashlib, time
def hash_str(s: str) -> str:
    return hashlib.sha256(s.encode('utf-8')).hexdigest()
def manifest_record(kind: str, model_family: str, model_version: str, temperature: float, seed: int, prompt_hash: str, redaction_hash: str):
    return {
        "ts": int(time.time()),
        "kind": kind,
        "model_family": model_family,
        "model_version": model_version,
        "temperature": temperature,
        "seed": seed,
        "prompt_hash": prompt_hash,
        "redaction_hash": redaction_hash,
    }
