import re
ZW = re.compile('[\u200B-\u200F\u202A-\u202E\u2060\uFEFF]')
HTML_COMMENT = re.compile('<!--.*?-->', re.DOTALL)
LATEX_COMMENT = re.compile('(^|[^\\])%.*$', re.MULTILINE)
LINK_TITLE = re.compile(r'\[(.*?)\]\((.*?)\)')
def sanitize(text: str) -> str:
    t = ZW.sub('', text)
    t = HTML_COMMENT.sub('', t)
    t = LATEX_COMMENT.sub('\\1', t)
    t = LINK_TITLE.sub(lambda m: m.group(1), t)
    return t
