




clear all;
close all;
clc;


%%

file_list = {'sgd','sgdm','adam','pid','lpfsgd','hpfsgd','fuzzypid'}


figure(1);
for i_plot=1:length(file_list)
    file = strcat('plot_', file_list{i_plot}, '.txt');
    fid = fopen(file,'rt');
    if fid == -1
        error('文件打开错误。')
    end
    loss = [];
    while 1
        nextline = fgetl(fid);
        if ~isstr(nextline), break, end
%         disp(nextline);
        a = sscanf(nextline, '%f');
        if (length(a)==4)
            loss = [loss; a(3)];
        else
            continue
        end
    end
    plot(loss, 'linewidth', 2);hold on;
end
hold off;
legend('SGD','SGDM','AdaM','PID','LPF-SGD','HPF-SGD','FuzzyPID', 'Fontsize', 14);
ylim([0 2.5]);
xlabel('\it Steps', 'Fontsize', 14);
ylabel('\it Loss', 'Fontsize', 14);




figure(2);
for i_plot=1:length(file_list)
    file = strcat('plot_', file_list{i_plot}, '.txt');
    fid = fopen(file,'rt');
    if fid == -1
        error('文件打开错误。')
    end
    acc = [];
    while 1
        nextline = fgetl(fid);
        if ~isstr(nextline), break, end
%         disp(nextline);
        a = sscanf(nextline, '%f');
        if (length(a)==4)
            acc = [acc; a(4)];
        else
            continue
        end
    end
    plot(acc, 'linewidth', 2);hold on;
end
hold off;
legend('SGD','SGDM','AdaM','PID','LPF-SGD','HPF-SGD','FuzzyPID', 'Fontsize', 14);
ylim([70 100]);
xlabel('\it Steps', 'Fontsize', 14);
ylabel('\it Accuracy Rate (%)', 'Fontsize', 14);


fclose('all')
