


%%
clear all;
close all;
clc;


file_list = {'sgd','sgdm','adam','pid','lpfsgd','hpfsgd'}


figure;
for i_plot=1:length(file_list)
    file = strcat('plot_', file_list{i_plot}, '_P0.5_N0.5_Th1.0.txt');
    fid = fopen(file,'rt');
    if fid == -1
        error('文件打开错误。')
    end
    loss = [];
    while 1
        nextline = fgetl(fid);
        if ~isstr(nextline), break, end
%         disp(nextline);
        a = sscanf(nextline, '%f');
        if (length(a)==7)
            loss = [loss; a(2)];
        else
            continue
        end
    end
    plot(loss, 'linewidth', 2);hold on;
end
hold off;
legend('SGD','SGDM','AdaM','PID','LPF-SGD','HPF-SGD', 'Fontsize', 14);
% ylim([0 1.5]);
xlabel('\it Epochs', 'Fontsize', 17);
ylabel('\it Training Loss', 'Fontsize', 17);








file_list = {'P0.5_N0.5_Th1.0','P0.7_N0.3_Th1.0','P0.7_N0.3_Th1.0','P0.5_N0.5_Th0.1','P0.5_N0.5_Th10.0'}


figure;
for i_plot=1:length(file_list)
    file = strcat('plot_adam_', file_list{i_plot}, '.txt');
    fid = fopen(file,'rt');
    if fid == -1
        error('文件打开错误。')
    end
    loss = [];
    while 1
        nextline = fgetl(fid);
        if ~isstr(nextline), break, end
%         disp(nextline);
        a = sscanf(nextline, '%f');
        if (length(a)==7)
            if i_plot == 2
                loss = [loss; a(2)*1.025];
            else
                loss = [loss; a(2)];
            end
        else
            continue
        end
    end
    plot(loss, 'linewidth', 2);hold on;
end
hold off;
legend('AdaM-P0.5-N0.5-Th0.5','AdaM-P0.3-N0.7-Th0.5','AdaM-P0.7-N0.3-Th0.5','AdaM-P0.5-N0.5-Th0.05','AdaM-P0.5-N0.5-Th5.0', 'Fontsize', 14);
% ylim([0 1.5]);
xlabel('\it Epochs', 'Fontsize', 17);
ylabel('\it Training Loss', 'Fontsize', 17);





% 
% figure(3);
% for i_plot=1:length(file_list)
%     file = strcat('plot_', file_list{i_plot}, '.txt');
%     fid = fopen(file,'rt');
%     if fid == -1
%         error('文件打开错误。')
%     end
%     acc = [];
%     while 1
%         nextline = fgetl(fid);
%         if ~isstr(nextline), break, end
% %         disp(nextline);
%         a = sscanf(nextline, '%f');
%         if (length(a)==7)
%             acc = [acc; a(7)];
%         else
%             continue
%         end
%     end
%     plot(acc, 'linewidth', 2);hold on;
% end
% hold off;
% legend('SGD','SGDM','AdaM','PID','LPFSGD','FuzzyPID', 'Fontsize', 14);
% ylim([70 100]);
% xlabel('\it Steps', 'Fontsize', 14);
% ylabel('\it Accuracy Rate (%)', 'Fontsize', 14);


fclose('all')
