classdef (Hidden, Sealed) ReaderGraphVizPlain < graph.reader.Reader
    %READERMAT Reads a graph problem from a GraphViz plain format file.
    %   This interface reads a GRAPH instance from a plain txt file
    %   generated by GraphViz.
    %
    %   See also: READER, GRAPH.
    
    %=========================== PROPERTIES ==============================
    properties (Constant, GetAccess = private)
        logger = core.logging.Logger.getInstance('graph.reader.ReaderGraphVizPlain')
    end
    
    %======================== IMPL: Reader ============================
    methods
        function metadata = readAdditionalMetadata(obj, metadata)
            % Nothing to read yet
        end
        
        function g = read(obj, metadata) %#ok<MANU>
            % Read a graph instance from metadata.file.
            
            % Read all variables (metadata, A; optional: coord)
            data    = load(metadata.file);
            f       = fopen(metadata.file ,'r');
            
            C = textscan(f, '%*s %d %f %f', 1);
            C2 = textscan(f, '%s %d %f %f %*s %*s %*s %*s %*s %*s %*s');
            nodeLines = find(strcmp(C2{1}, 'node'));
            C2{2}(nodes)
            coord = [C2{3}(nodes) C2{4}(nodes)];
            
            fclose(f);

            % Create graph instance
            if (isvarname('data.coord'))
                g = graph.api.Graph.newInstanceFromMetadata(data.metadata, data.A, data.coord);
            else
                g = graph.api.Graph.newInstanceFromMetadata(data.metadata, data.A);
            end
        end
    end
    
end
