function suite_lamg
%SUITE_LAMG LAMG module test suite.
%   MATLAB XUnit 2.0.1 does not yet support test suite directory scanning.
%   Therefore we manually add all tests to the source of this function.

%clear all

testClasses = { ...
    'amg.relax.UTestGsRelaxMex', ...
    'amg.relax.UTestRelaxAcf', ...
    'amg.relax.UTestRelaxAcfGrid', ...
    'amg.relax.UTestRelaxWofGrid', ...
    ...
    'amg.coarse.UTestAggregator', ...
    'amg.coarse.UTestMedianColMex', ...
    'amg.coarse.UTestLowDegreeNodesMex', ...
    'amg.coarse.UTestAggregationSweepMex', ...
    'amg.coarse.UTestAffinityMatrixMex', ...
    'amg.coarse.UTestFilterSmallEntriesMex', ...
    'amg.coarse.UTestUndecidedNodesMex', ...
    'amg.coarse.UTestEliminationOperatorsMex', ...
    'amg.coarse.UTestGalerkinEliminationMex', ...
    ...
    'amg.setup.UTestGalerkinCaliber1Mex', ...
    ...
    'amg.cycle.UTestCycleCounters', ...
    'amg.cycle.UTestCycleCountersState', ...
    ...
    'amg.solve.UTestCycleAcfGrid1d', ...
    'amg.solve.UTestCycleAcfGrid2dTwoLevel', ...
    'amg.solve.UTestConnectedComponents', ...
    'amg.solve.UTestElimination', ...
    'amg.solve.UTestCycleAcfGraph', ...
    'amg.solve.UTestRunCycleAcf', ...
    'amg.solve.UTestLamg' ...
    };

% Deprecated tests
%     ...
%     'amg.energy.UTestFitterGriddyLs', ... % Relies on MATLAB toolsbox input file 'hald'

runSuite(testClasses);
end

%-------------------------------------------------------
function runSuite(testClasses)
% Run test suites and print pass/fail result
tstart = tic;
fprintf('Suite: %d classes\n', numel(testClasses));
did_pass = runTests(testClasses);
if did_pass
    result = 'PASSED';
else
    result = 'FAILED';
end
fprintf('Suite %s %6.2f sec\n', result, toc(tstart));
end

%-------------------------------------------------------
function did_pass = runTests(testClasses)
did_pass = 1;
for testClass = testClasses
    did_pass = did_pass & runtests(testClass{1});
end
end
