function coord = readGraphCoord(file)
%READGRAHPCOORD Reads a graph 2-D node coordinates from a GraphViz plain
%format file.
%   This class reads node planar coordinates from a plain txt file
%   generated by GraphViz.
%
%   See also: READER, GRAPH.

% Read all variables (metadata, A; optional: coord)
f  = fopen(file ,'r');

% Read graph header line
textscan(f, '%*s %d %f %f', 1);

% Read node lines until failure
C2 = textscan(f, '%s %d %f %f %*s %*s %*s %*s %*s %*s %*s');

% Remove failed line (probably an edge line or a stop line)
nodeLines = find(strcmp(C2{1}, 'node'));
coord = [C2{3}(nodeLines) C2{4}(nodeLines)];
fclose(f);

end
