#!/bin/bash

CKPT="llava-v1.5-7b"
SPLIT="val"
OUTPUT_DIR=data/vqav2/answers/$SPLIT/$CKPT
output_file=$OUTPUT_DIR/merge.jsonl
echo $output_file

if [ ! -f "$output_file" ]; then
    echo "output file $output_file does not exist, running evaluation"
    
    gpu_list="${CUDA_VISIBLE_DEVICES:-0}"
    echo $gpu_list
    IFS=',' read -ra GPULIST <<< "$gpu_list"

    CHUNKS=${#GPULIST[@]}
    
    for IDX in $(seq 0 $((CHUNKS-1))); do
        CUDA_VISIBLE_DEVICES=${GPULIST[$IDX]} srun python -m llava.eval.model_vqa_loader \
            --model-path liuhaotian/llava-v1.5-7b \
            --question-file data/vqav2/val_questions_llava.jsonl \
            --image-folder data/vqav2/val2014 \
            --answers-file $OUTPUT_DIR/${CHUNKS}_${IDX}.jsonl \
            --num-chunks $CHUNKS \
            --chunk-idx $IDX \
            --temperature 0 \
            --conv-mode vicuna_v1 &
    done

    wait

    echo "merging results to $output_file"

    # Clear out the output file if it exists.
    > "$output_file"

    # Loop through the indices and concatenate each file.
    for IDX in $(seq 0 $((CHUNKS-1))); do
        cat $OUTPUT_DIR/${CHUNKS}_${IDX}.jsonl >> "$output_file"
    done
fi
