#!/bin/bash

MASTER_ADDR=localhost
GPUS_PER_NODE=8 # change back to 8
NNODES=1

python -u -m torch.distributed.run \
   --nproc_per_node $GPUS_PER_NODE \
    --nnodes $NNODES \
    --node_rank 0 \
    --rdzv_endpoint $MASTER_ADDR:0 \
    --rdzv_backend c10d \
    -m llava.train.train_mem \
    --deepspeed ./scripts/zero3.json \
    --model_name_or_path lmsys/vicuna-7b-v1.5 \
    --version v1 \
    --data_path data/llava_visual_inst_tuning/data/llava_v1_5_mix665k.json \
    --image_folder data/llava_visual_inst_tuning/data \
    --vision_tower timm/vit_large_patch14_clip_224.laion400m_e32 \
    --pretrain_mm_mlp_adapter checkpoints/llava-v1.5-7b-timm__vit_large_patch14_clip_224.laion400m_e32/mm_projector.bin \
    --mm_projector_type mlp2x_gelu \
    --mm_vision_select_layer -2 \
    --mm_use_im_start_end False \
    --mm_use_im_patch_token False \
    --image_aspect_ratio pad \
    --group_by_modality_length True \
    --bf16 True \
    --output_dir checkpoints/llava-v1.5-7b-timm__vit_large_patch14_clip_224.laion400m_e32 \
    --num_train_epochs 1 \
    --per_device_train_batch_size 16 \
    --per_device_eval_batch_size 4 \
    --gradient_accumulation_steps 1 \
    --evaluation_strategy "no" \
    --save_strategy "steps" \
    --save_steps 50000 \
    --save_total_limit 1 \
    --learning_rate 2e-5 \
    --weight_decay 0. \
    --warmup_ratio 0.03 \
    --lr_scheduler_type "cosine" \
    --logging_steps 1 \
    --tf32 True \
    --model_max_length 2048 \
    --gradient_checkpointing True \
    --dataloader_num_workers 4 \
    --lazy_preprocess True \
    --report_to wandb
