## Environment setup
```
conda create --name GraphPack python=3.9 -y
conda activate GraphPack

# https://pytorch.org/get-started/locally/
pip install torch==2.1.0 torchvision==0.16.0 torchaudio==2.1.0 --index-url https://download.pytorch.org/whl/cu118


python -c "import torch; print(torch.__version__)"
python -c "import torch; print(torch.version.cuda)"
pip install pyg_lib torch_scatter torch_sparse torch_cluster torch_spline_conv -f https://data.pyg.org/whl/torch-2.1.0+cu118.html

pip install peft
pip install pandas
pip install ogb
pip install transformers
pip install wandb
pip install sentencepiece
pip install torch_geometric
pip install datasets
pip install pcst_fast
pip install gensim
pip install scipy=1.12
```

## Data Preprocessing
```
# webqsp
python -m src.dataset.preprocess.webqsp
python -m src.dataset.webqsp

#cwq
python -m src.dataset.preprocess.cwq
python -m src.dataset.cwq
```


## Training
```
# GraphPack
CUDA_VISIBLE_DEVICES=0 python train.py --dataset webqsp --model_name graph_llm
CUDA_VISIBLE_DEVICES=0 python train.py --dataset cwq --model_name graph_llm
```
