from src.model.llm import LLM
from src.model.pt_llm import PromptTuningLLM
from src.model.graph_llm import GraphLLM
# from src.model.graphllm_qformer import GraphLLM
from .loader import load_config, load_model, load_tokenizer
from .model_utils.misc import find_all_linear_modules
from .model_utils.quantization import QuantizationMethod
from .model_utils.valuehead import load_valuehead_params

load_model = {
    "llm": LLM,
    "inference_llm": LLM,
    "pt_llm": PromptTuningLLM,
    "graph_llm": GraphLLM,
}

# Replace the following with the model paths
llama_model_path = {
    "7b": "/data1/hub/shakechen/Llama-2-7b-hf/",
    "7b-chat": "/home/amax/.cache/modelscope/hub/shakechen/Llama-2-7b-chat-hf/",
    "vicuna-7b": "/home/amax/.cache/modelscope/hub/AI-ModelScope/vicuna-7b-v1___5/",
    "8b": "/home/amax/.cache/modelscope/hub/LLM-Research/Meta-Llama-3-8B/",
    "13b": "meta-llama/Llama-2-13b-hf",
    "13b-chat": "meta-llama/Llama-2-13b-chat-hf",
    "1b": "/amax/storage/nfs/vpcctrl/d7/huggingface/LLM-Research/Llama-3___2-1B/",
    "qwen": "/amax/storage/nfs/vpcctrl/d7/huggingface/qwen/Qwen2.5-Coder-3B-Instruct/"
}

__all__ = [
    "QuantizationMethod",
    "load_config",
    "load_model",
    "load_tokenizer",
    "find_all_linear_modules",
    "load_valuehead_params",
]
