from src.dataset.expla_graphs import ExplaGraphsDataset
from src.dataset.scene_graphs import SceneGraphsDataset
from src.dataset.scene_graphs_baseline import SceneGraphsBaselineDataset
from src.dataset.webqsp import WebQSPDataset
from src.dataset.cwq import CWQDataset
from src.dataset.webqsp_gr import WebQSPDatasetGR
from src.dataset.webqsp_baseline import WebQSPBaselineDataset
from src.dataset.glbench import GLBenchDataset


load_dataset = {
    'expla_graphs': ExplaGraphsDataset,
    'scene_graphs': SceneGraphsDataset,
    'scene_graphs_baseline': SceneGraphsBaselineDataset,
    'webqsp': WebQSPDataset,
    'webqsp-gr': WebQSPDatasetGR,
    'webqsp_baseline': WebQSPBaselineDataset,
    'glbench': GLBenchDataset,
    'cwq': CWQDataset
}
