# A lightweight Transformer Guided by Features from Multiple Receptive Fields for Few-shot Fine-Grained Image Classification

![Alt text](Figure/network.png)

## Code Environment
```
conda env create -f environment.yml
conda activate LT_FMRF
```
## Data Preparation
About CUB_200_2011, Stanford Dogs, Stanford Cars.
Please proceed with the setting up data by referring to [BiFRN Github](https://github.com/PRIS-CV/Bi-FRN?tab=readme-ov-file#dataset).
meta-iNat and tiered-meta-iNat data Settings follow [FRN Github](http://github.com/Tsingularity/FRN#setting-up-data).

## Train
- To train LT-FMRF on CUB_fewshot_cropped with Conv-4 backbone under the 1/5-shot setting, run the following command lines:
```
cd experiments/CUB_fewshot_cropped/LT_FMRF/Conv-4
chemod +x train.sh
./train.sh
```
- For ResNet-12 backbone, run the following command lines:
```
cd experiments/CUB_fewshot_cropped/LT_FMRF/ResNet-12
chemod +x train.sh
./train.sh
```

## Test
If you want to test, use the following command:
```
cd experiments/CUB_fewshot_cropped/LT_FMRF/Conv-4
python test.py
cd experiments/CUB_fewshot_cropped/LT_FMRF/ResNet-12
python test.py
```