import ffmpeg


import logging
import os


def convert_to_wav(infile, outdir) -> str:
    basename, extension = os.path.basename(infile.replace("gs://", "")).rsplit(
        ".", maxsplit=1
    )
    outfile = os.path.join(outdir, f"{basename}.wav")
    print(
        f"[DEBUG] running ffmppeg with input {infile} from {extension} to wav {outfile}"
    )
    try:
        ffmpeg.input(infile).output(
            outfile,
            ar=44100,
            ac=1,
        ).overwrite_output().run(capture_stdout=True)
        return outfile

    except Exception as e:
        logging.error(f"error processing file {infile} to {outfile}: {e}")
        return None