from .jsonify import *

_JSONIFIERS = {
    "jamendo": JamendoJsonifier,
    "fma": FmaJsonifier,
    "fsl10k": Fsl10kJsonifier,
    "wavcaps": WavCapsJsonifier,
    "giantsteps-key": GiantStepsKeyJsonifier,
    "giantsteps-tempo": GiantStepsTempoJsonifier,
    "magnatagatune": MagnaTagATuneJsonifier,
    "yt8m-musictextclips": YT8MMusicTextClipsJsonifier,
    "musicnet": MusicNetJsonifier,
    "musiccaps": MusiccapsJsonifier,
    "slakh": SlakhJsonifier,
}


def get_jsonifier(dataset: str, *args, **kwargs) -> DatasetJsonifier:
    assert (
        dataset in _JSONIFIERS
    ), f"dataset {dataset} not in valid datasets {_JSONIFIERS.keys()}"
    cls = _JSONIFIERS[dataset]
    return cls(name=dataset, *args, **kwargs)
