"""
Script to split slakh into separate dirs for audio and midi.
Usage:

python scripts/split_slakh.py \
    --input-dir ~/slakh2100_flac_redux/train \
    --output-dir ~/slakh2100-preprocessed/train

python scripts/split_slakh.py \
    --input-dir ~/slakh2100_flac_redux/test \
    --output-dir ~/slakh2100-preprocessed/test
"""
import argparse
import os
import shutil
from tqdm import tqdm

parser = argparse.ArgumentParser()
parser.add_argument("--input-dir")
parser.add_argument("--output-dir")

args = parser.parse_args()

tracks = [x for x in os.listdir(args.input_dir) if "Track" in x]
for track in tqdm(tracks):
    mix_file = os.path.join(args.input_dir, track, "mix.flac")
    midi_file = os.path.join(args.input_dir, track, "all_src.mid")
    shutil.copyfile(mix_file, os.path.join(args.output_dir, "flac", track + ".flac"))
    shutil.copyfile(midi_file, os.path.join(args.output_dir, "midi", track + ".mid"))
