import gym
from d4rl.pointmaze.waypoint_controller import WaypointController
from d4rl.pointmaze.maze_model import U_MAZE,MEDIUM_MAZE,LARGE_MAZE
import numpy as np
from copy import deepcopy


ZEROS = np.zeros((2,), dtype=np.float32)
ONES = np.zeros((2,), dtype=np.float32)


class Controller(WaypointController):
    def __init__(self, maze_str):
        super().__init__(maze_str)
        

    def reset(self):
        self._target = -1000 * ONES


class Expert:
    def __init__(self,env):
        # self.env = deepcopy(env)
        
        
        self.controller = Controller(env.str_maze_spec)


    def set_seed(self,seed=None):
        if(seed != None):
            self.seed = seed
            np.random.seed(seed)
            # self.env.seed(seed)
            # self.env.action_space.seed(seed)
        return self.seed
    def reset(self):
        self.controller.reset()
                
    def sample(self,x,target):
        start = deepcopy(np.array([x[0],x[1]]))
        verity = deepcopy(np.array([x[2],x[3]]))
        act,_ = self.controller.get_action(start,verity,target)
        return act