# IFILA

## Datasets used in the project

- NoRobots (https://huggingface.co/datasets/HuggingFaceH4/no_robots), Licensing Information: CC BY-NC 4.0.
- LIMA (https://huggingface.co/datasets/GAIR/lima), Licensing Information: CC BY-NC-SA. 
- Alpaca-GPT4 (https://huggingface.co/datasets/vicgalle/alpaca-gpt4), Licensing Information: CC BY-NC 4.0.

## Reference Code
- MT-Bench (https://github.com/lm-sys/FastChat)
- LM-Evaluation-Harness (https://github.com/EleutherAI/lm-evaluation-harness)
- QLoRA (https://github.com/artidoro/qlora)

## Machine Environment
- Ubuntu 20.04
- Python 3.9
- CUDA 12.1
- 4 NVIDIA GeForce A100 GPUs

## Installation
1. Install Python 3.9, Pytorch

2. Install our project
```bash
cd ./IFILA
pip install -U -r requirements.txt
```

3. Install the evaluation environment:
```bash
cd ..
git clone https://github.com/EleutherAI/lm-evaluation-harness
cd lm-evaluation-harness
pip install -e .

cd ..
git clone https://github.com/lm-sys/FastChat.git
cd FastChat
pip install -e ".[model_worker,llm_judge]"
```
