#!/usr/bin/env bash

EXPERIMENT_NAME="filter_size"
RUN_NAME="synthetic"

# Parameters to loop over
NOISE_FRACTION=("0.0" "0.2")
NUM_SEEDS=5
NUM_INNER_SEEDS=15
WIDTH=128
PEAK_LR="0.2"

# Determine common paths
REPOSITORY_DIR="$(realpath $(dirname $BASH_SOURCE)/../../)"
MODULE_DIR="${REPOSITORY_DIR}/src"
DATA_CACHE_DIR="/tmp"  # TODO: Change

# Append Python module to python path in order to more cleanly call the experiment
export PYTHONPATH="${MODULE_DIR}:${PYTHONPATH}"

RUN_SCRIPT="${REPOSITORY_DIR}/config/paper_${EXPERIMENT_NAME}/run_${RUN_NAME}.sh"

for noise_fraction in "${NOISE_FRACTION[@]}"; do
  for seed in $(seq 1 $NUM_SEEDS); do
    echo "Running for noise ${noise_fraction} and seed ${seed} with ${NUM_INNER_SEEDS} training seeds"
    for training_seed in $(seq 1 $NUM_INNER_SEEDS); do
      for filter_size in {5..32} ; do
        echo "Filter size ${filter_size}"
        python -m filter_size --experiment "paper_${EXPERIMENT_NAME}_${RUN_NAME}" \
          --config "${REPOSITORY_DIR}/config/paper_${EXPERIMENT_NAME}/${RUN_NAME}.gin" \
          --bindings \
            "filter_size=${filter_size}" \
            "noise_fraction=${NOISE_FRACTION}" \
            "seed=${seed}" \
            "training_seed=${training_seed}" \
            "width=${WIDTH}" \
            "lr_schedule_peak_value=${PEAK_LR}" \
            "cache_dir='${DATA_CACHE_DIR}'"
      done
    done
  done
done
