import math as mt

import numpy as np


def Plots(b_points=10000, Ln=2, Lreg=0, r=0.4, l=2, b_min=0.1, toll=0.000001):
    def Var(L_reg, L_n, r, b):
        d = (L_n - L_reg - 1) / b - mt.floor((L_n - L_reg - 1) / b)
        return (-L_reg - r - b * min(d, 1 - d)) / L_n

    def Bias(L_reg, L_n, b, L_gt):
        return 2 * (L_reg - L_n + 1 + b * (L_gt - 1)) / L_n

    def Optimize(L_n, b, L_gt):
        lower_bound = -Bias(0, L_n, b, L_gt)
        L = lower_bound / 2
        jump = lower_bound / 4
        while jump >= toll * 2:
            obj = Bias(L, L_n, b, L_gt) - Var(L, L_n, r, b)
            L = L - jump * (2 * (obj > 0) - 1)
            jump = jump / 2
        return L

    bs = np.linspace(b_min, 1, b_points + 1)[2:-1]
    var_s = np.zeros(bs.shape[0])
    bias_s = np.zeros(bs.shape[0])

    L_opt = np.zeros(bs.shape[0])
    var_s_opt = np.zeros(bs.shape[0])
    bias_s_opt = np.zeros(bs.shape[0])

    for i, b in enumerate(bs):
        var_s[i] = Var(0, Ln, r, b)
        bias_s[i] = Bias(0, Ln, b, l)

        L_opt[i] = Optimize(Ln, b, l)

        var_s_opt[i] = Var(L_opt[i], Ln, r, b)
        bias_s_opt[i] = Bias(L_opt[i], Ln, b, l)

    th = 0
    for (i, b) in enumerate(bs):
        if bias_s[i] >= var_s[i]:
            # print(i)
            th = bs[i]
            break

    rate_s = np.max(np.vstack((var_s, bias_s)), axis=0)
    rate_s_opt = np.max(np.vstack((var_s_opt, bias_s_opt)), axis=0)

    return th, bs, rate_s, rate_s_opt, var_s, bias_s
