#! /usr/bin/env bash

export PYTHONPATH=$PYTHONPATH:$(pwd)

DATASET=cifar10

# ===================================

LEVEL=5

if [ "$#" -lt 2 ]; then
	CORRUPT=cifar_new

	# METHOD=ssl
	# METHOD=align
	METHOD=both
	NSAMPLE=100000
else
	CORRUPT=$1
	METHOD=$2
	NSAMPLE=$3
fi

# ===================================

SCALE_EXT=0.2
# SCALE_EXT=0.01
SCALE_SSH=0.2
LR=0.001
BS_SSL=256
BS_ALIGN=256
QS=1536
# BS_SSL=200
# BS_ALIGN=200
# QS=1200
DIVERGENCE=all

echo 'DATASET: '${DATASET}
echo 'CORRUPT: '${CORRUPT}
echo 'METHOD:' ${METHOD}
echo 'DIVERGENCE:' ${DIVERGENCE}
echo 'LR:' ${LR}
echo 'SCALE_EXT:' ${SCALE_EXT}
echo 'SCALE_SSH:' ${SCALE_SSH}
echo 'BS_SSL:' ${BS_SSL}
echo 'NSAMPLE:' ${NSAMPLE}

# ===================================

printf '\n---------------------\n\n'

	# nohup python ttt++.py \
	# --dataroot ${DATADIR} \
	# --resume results/${DATASET}_joint_resnet18 \
	# --outf results/${DATASET}_ttt_simclr_joint_resnet18 \
	# --corruption ${CORRUPT} \
	# --level ${LEVEL} \
	# --workers 8 \
	# --fix_ssh \
	# --batch_size ${BS_SSL} \
	# --batch_size_align ${BS_ALIGN} \
	# --queue_size ${QS} \
	# --lr ${LR} \
	# --scale_ext ${SCALE_EXT} \
	# --scale_ssh ${SCALE_SSH} \
	# --method ${METHOD} \
	# --divergence ${DIVERGENCE} \
	# --align_ssh \
	# --align_ext \
	# --num_sample ${NSAMPLE} \
	# --app app:/home/lishuang/clc/tttpp/tttpp/cifar/slim_net/apps/s_resnet50_train_val.yml > c10_1output/ttt++_res18.log &
	# --tsne

	nohup python slimttt.py \
	--dataroot ${DATADIR} \
	--resume results/${DATASET}_joint_slim_resnet50 \
	--outf results/${DATASET}_ttt_simclr_slim_joint_resnet50 \
	--corruption ${CORRUPT} \
	--level ${LEVEL} \
	--workers 8 \
	--batch_size ${BS_SSL} \
	--batch_size_align ${BS_ALIGN} \
	--queue_size ${QS} \
	--lr ${LR} \
	--scale_ext ${SCALE_EXT} \
	--scale_ssh ${SCALE_SSH} \
	--method ${METHOD} \
	--divergence ${DIVERGENCE} \
	--align_ssh \
	--align_ext \
	--num_sample ${NSAMPLE} \
	--app app:/home/lishuang/clc/tttpp/tttpp/cifar/slim_net/apps/s_resnet50_train_val.yml > c10_1output/ttt++_ensemble_final4.log &
	# --tsne