import json
import matplotlib.pyplot as plt
import numpy as np
import pandas as pd
import seaborn
import csv,math
import scipy.stats as stats
color_set = {
        'Amaranth': np.array([0.9, 0.17, 0.31]),  # main algo
        'Amber': np.array([1.0, 0.49, 0.0]),  # main baseline
        'Bleu de France': np.array([0.19, 0.55, 0.91]),
        'Electric violet': np.array([0.56, 0.0, 1.0]),
        'Dark sea green': 'forestgreen',
        'Dark electric blue': 'deeppink',
        'Dark gray': np.array([0.66, 0.66, 0.66]),
        'Arsenic': np.array([0.23, 0.27, 0.29]),
    }

color_list = []
for key,value in color_set.items():
    color_list.append(value)

def legend():
    plt.legend(loc='best', prop={'size': 15.0}, frameon=True, ncol=1)
    plt.tight_layout()



def smooth_new(data, weight=0.7):
    """
    EMA implementation according to
    https://github.com/tensorflow/tensorboard/blob/34877f15153e1a2087316b9952c931807a122aa7/tensorboard/components/vz_line_chart2/line-chart.ts#L699
    """
    last = np.zeros_like(data[:,0:1])
    smoothed = np.zeros_like(data)
    num_acc = 0
    for i in range(0, data.shape[-1]):
        last = last * weight + (1 - weight) * data[:,i]
        num_acc += 1
        # de-bias
        debias_weight = 1
        if weight != 1:
            debias_weight = 1 - math.pow(weight, num_acc)
        smoothed_val = last / debias_weight
        smoothed[:,i]=smoothed_val

    return smoothed

def smooth(data, smooth_range):
	# print('hhhhhhh', type(data), len(data))
	new_data = np.zeros_like(data)
	for i in range(0, data.shape[-1]):
		if i < smooth_range:
			new_data[:, i] = 1. * np.sum(data[:, :i + 1], axis=1) / (i + 1)
		else:
			new_data[:, i] = 1. * np.sum(data[:, i - smooth_range + 1:i + 1], axis=1) / smooth_range

	return new_data


def read_data_2(paths=[],smoothed=30):
	final_datas = {'x':[],'sr':[],'return':[]}
	min_length = 100000000000
	for p in paths:
		datas = []
		with open(p,'r') as f:
			for l in f.readlines():
				datas.append(json.loads(l))
		x = np.zeros((len(datas)))
		sr = np.zeros((len(datas)))
		returns = np.zeros((len(datas)))
		# srs = np.zeros((25, len(datas)))
		for num, d in enumerate(datas):
			if 'episode' in d.keys() and 'success' in d.keys():
				x[num] = d['episode']
				# sr[num] = d['success_env_index_11'  if '136' not in paths[0] else 'success_env_index_2']
				#sr[num] = d['success']
				for i in range(10):
					returns[num] += d['episode_reward_env_index_%d'%i]/10
				sr[num] = d['success']
			# for j in range(25):
			# 	srs[j][num] = d['success_env_index_' + '%d' % j]
		sr = smooth(sr[None], smoothed)[0]
		returns = smooth(returns[None], smoothed)[0]
		# srs = smooth(srs, smoothed)
		final_datas['x'].append(x[None])
		final_datas['sr'].append(sr[None])
		final_datas['return'].append(returns[None])
		if x.shape[0]<min_length:
			min_length = x.shape[0]
	for i in range(len(final_datas['x'])):
		final_datas['x'][i] = final_datas['x'][i][:,:min_length]
		final_datas['sr'][i] = final_datas['sr'][i][:, :min_length]
		final_datas['return'][i] = final_datas['return'][i][:, :min_length]
	final_datas['x'] = np.concatenate(final_datas['x'],0) * 500 * 10 /1e6
	final_datas['sr'] = np.concatenate(final_datas['sr'], 0)
	final_datas['return'] = np.concatenate(final_datas['return'], 0)
	return final_datas, min_length


def read_attr(csv_path, attr):
    with open(csv_path) as csv_file:
        reader = csv.reader(csv_file, delimiter='\t')
        try:
            row = next(reader)
        except Exception:
            return None
        if attr not in row:
            return None
        idx = row.index(attr)  # the column number for this attribute
        vals = []
        for row in reader:
            vals.append(row[idx])

    vals = [np.nan if v=='' else v for v in vals]
    return np.array(vals, dtype=np.float64)




def read_data_txt_analyse(paths=[],smoothed=20):
	final_datas = {'x':[],'sr':[],'return':[]}
	min_length = 1000000000000
	for p in paths:
		data = np.loadtxt(p)
		x = data[:,0]
		# sr = read_attr(p, 'Success')
		returns = data[:,1]
		x = smooth(x[None], smoothed)[0]
		# sr = smooth(sr[None], smoothed)[0]
		returns = smooth(returns[None], smoothed)[0]
		# returns = smooth_new(returns[None], 0.7)[0]
		final_datas['x'].append(x[None])
		# final_datas['sr'].append(sr[None])
		final_datas['return'].append(returns[None])
		if returns.shape[0]<min_length:
			min_length = x.shape[0]
	for i in range(len(final_datas['return'])):
		final_datas['x'][i] = final_datas['x'][i][:,:min_length]
		# final_datas['sr'][i] = final_datas['sr'][i][:, :min_length]
		final_datas['return'][i] = final_datas['return'][i][:, :min_length]
	final_datas['x'] = np.concatenate(final_datas['x'],0)
	# final_datas['sr'] = np.concatenate(final_datas['sr'], 0)
	final_datas['return'] = np.concatenate(final_datas['return'], 0)
	ys = final_datas['return']
	ys += np.random.rand(ys.shape[0], ys.shape[1]) * 1e-3
	confidence_interval = stats.bootstrap((ys,), np.mean, axis=1)
	low = confidence_interval.confidence_interval.low
	high = confidence_interval.confidence_interval.high
	# print(low.shape,high.shape,ys.shape)
	mean = np.mean(np.array([low, high]), 0)
	# mean = np.mean(ys, 1)
	interval_distance = high - mean
	mean = np.mean(ys,0)
	interval_distance = np.std(ys,0)
	return [mean, interval_distance], min_length

def read_data_multipolar(paths=[],smoothed=30):
	final_datas = {'x': [], 'sr': [], 'return': []}
	min_length = 1500
	for p in paths:
		data = pd.read_csv(p)
		value_steps = data['l'].values
		return_steps = data['r'].values
		success = data['success'].values
		value_steps = np.arange(1,1+value_steps.shape[0])*500*8 /1e6
		x = smooth(value_steps[None], smoothed)[0]
		sr = smooth(success[None], smoothed)[0]
		returns = smooth(return_steps[None], smoothed)[0]
		# srs = smooth(srs, smoothed)
		final_datas['x'].append(x[None])
		final_datas['sr'].append(sr[None])
		final_datas['return'].append(returns[None])
		if x.shape[0] < min_length:
			min_length = x.shape[0]
	for i in range(len(final_datas['x'])):
		final_datas['x'][i] = final_datas['x'][i][:, :min_length]
		final_datas['sr'][i] = final_datas['sr'][i][:, :min_length]
		final_datas['return'][i] = final_datas['return'][i][:, :min_length]
	final_datas['x'] = np.concatenate(final_datas['x'], 0)
	final_datas['sr'] = np.concatenate(final_datas['sr'], 0)
	final_datas['return'] = np.concatenate(final_datas['return'], 0)
	return final_datas, min_length

def read_data_ptf(paths=[],smoothed=30):
	final_datas = {'x': [], 'sr': [], 'return': []}
	min_length = 1200
	for p in paths:
		data = pd.read_csv(p)
		value_steps = data['Step'].values
		return_steps = data['Value'].values
		success = data['Value'].values
		value_steps = value_steps*500*10 /1e6
		x = smooth(value_steps[None], smoothed)[0]
		sr = smooth(success[None], smoothed)[0]
		returns = smooth(return_steps[None], smoothed)[0]
		# srs = smooth(srs, smoothed)
		final_datas['x'].append(x[None])
		final_datas['sr'].append(sr[None])
		final_datas['return'].append(returns[None])
		if x.shape[0] < min_length:
			min_length = x.shape[0]
	for i in range(len(final_datas['x'])):
		final_datas['x'][i] = final_datas['x'][i][:, :min_length]
		final_datas['sr'][i] = final_datas['sr'][i][:, :min_length]
		final_datas['return'][i] = final_datas['return'][i][:, :min_length]
	final_datas['x'] = np.concatenate(final_datas['x'], 0)
	final_datas['sr'] = np.concatenate(final_datas['sr'], 0)
	final_datas['return'] = np.concatenate(final_datas['return'], 0)
	return final_datas, min_length

def read_data_npy(paths=[],smoothed=30,scale=1):
	final_datas = {'x':[],'sr':[],'return':[]}
	min_length = 100000000000
	datas = []
	for p in paths:
		datas.append(np.load(p)[None,:])
	for i in range(len(datas)):
		min_length=min(min_length,datas[i].shape[1])
	for i in range(len(datas)):
		datas[i]=datas[i][:,:min_length]
	datas=np.concatenate(datas,0)
	print(datas[:,-1])
	datas = datas*scale
	x = np.zeros_like(datas)
	returns = datas
	for i in range(x.shape[0]):
		x[i]=(np.arange(x.shape[1])+1)/200*1.5#*5e3


	returns = smooth(returns, smoothed)

	final_datas['x'] = x
	final_datas['sr'] = returns
	final_datas['return'] =returns
	return final_datas, None

def read_data_weight(paths=[],smoothed=30):
	final_datas = {'x':[],'sr':[],'return':[]}
	min_length = 100000000000
	for p in paths:
		datas = []
		with open(p,'r') as f:
			for l in f.readlines():
				datas.append(json.loads(l))
		x = np.zeros((len(datas)))
		sr = np.zeros((len(datas)))
		returns = np.zeros((len(datas)))
		# srs = np.zeros((25, len(datas)))
		for num, d in enumerate(datas):
			if 'episode' in d.keys() and 'Q_weight' in d.keys():
				x[num] = d['episode']
				# sr[num] = d['success_env_index_11'  if '136' not in paths[0] else 'success_env_index_2']
				#sr[num] = d['success']
				for i in range(10):
					returns[num] += 0
				returns[num] = d['Q_weight']
				sr[num] = d['Q_weight']
			# for j in range(25):
			# 	srs[j][num] = d['success_env_index_' + '%d' % j]
		sr = smooth(sr[None], smoothed)[0]
		returns = smooth(returns[None], smoothed)[0]
		# srs = smooth(srs, smoothed)
		final_datas['x'].append(x[None])
		final_datas['sr'].append(sr[None])
		final_datas['return'].append(returns[None])
		if x.shape[0]<min_length:
			min_length = x.shape[0]
	for i in range(len(final_datas['x'])):
		final_datas['x'][i] = final_datas['x'][i][:,:min_length]
		final_datas['sr'][i] = final_datas['sr'][i][:, :min_length]
		final_datas['return'][i] = final_datas['return'][i][:, :min_length]
	final_datas['x'] = np.concatenate(final_datas['x'],0) * 500 * 10
	final_datas['sr'] = np.concatenate(final_datas['sr'], 0)
	final_datas['return'] = np.concatenate(final_datas['return'], 0)
	return final_datas, min_length


def read_data_csv(paths=[],smoothed=30):
	final_datas = {'x':[],'sr':[],'return':[]}
	min_length = 100000000000
	for p in paths:
		data = pd.read_csv(p)
		# value_steps = data['Step'].values
		return_steps = data['average_normalized_return'].values
		value_steps = np.arange(return_steps.shape[0])*10
		x = smooth(value_steps[None], smoothed)[0]
		sr = smooth(return_steps[None], smoothed)[0]
		returns = smooth(return_steps[None], smoothed)[0]
		# srs = smooth(srs, smoothed)
		final_datas['x'].append(x[None])
		final_datas['sr'].append(sr[None])
		final_datas['return'].append(returns[None])
		if x.shape[0]<min_length:
			min_length = x.shape[0]
	for i in range(len(final_datas['x'])):
		final_datas['x'][i] = final_datas['x'][i][:,:min_length]
		final_datas['sr'][i] = final_datas['sr'][i][:, :min_length]
		final_datas['return'][i] = final_datas['return'][i][:, :min_length]
	final_datas['x'] = np.concatenate(final_datas['x'],0) * 500 /1e6
	final_datas['sr'] = np.concatenate(final_datas['sr'], 0)
	final_datas['return'] = np.concatenate(final_datas['return'], 0)
	return final_datas, min_length

def read_data_npy_analyse(paths=[],smoothed=20):
	final_datas = {'x':[],'sr':[],'return':[]}
	min_length = 100000000000
	for p in paths:
		data = np.load(p)
		# value_steps = data['Step'].values
		return_steps = data
		value_steps = np.arange(return_steps.shape[0])*10
		x = smooth(value_steps[None], smoothed)[0]
		sr = smooth(return_steps[None], smoothed)[0]
		returns = smooth(return_steps[None], smoothed)[0]
		# srs = smooth(srs, smoothed)
		final_datas['x'].append(x[None])
		final_datas['sr'].append(sr[None])
		final_datas['return'].append(returns[None])
		if x.shape[0]<min_length:
			min_length = x.shape[0]
	for i in range(len(final_datas['x'])):
		final_datas['x'][i] = final_datas['x'][i][:,:min_length]
		final_datas['sr'][i] = final_datas['sr'][i][:, :min_length]
		final_datas['return'][i] = final_datas['return'][i][:, :min_length]
	final_datas['x'] = np.concatenate(final_datas['x'],0) * 500 /1e6
	final_datas['sr'] = np.concatenate(final_datas['sr'], 0)
	final_datas['return'] = np.concatenate(final_datas['return'], 0)
	ys = final_datas['return']
	confidence_interval = stats.bootstrap((ys,), np.mean, axis=1)
	low = confidence_interval.confidence_interval.low
	high = confidence_interval.confidence_interval.high
	# print(low.shape,high.shape,ys.shape)
	mean = np.mean(np.array([low, high]), 0)
	interval_distance = high - mean

	mean = np.mean(ys,0)
	interval_distance = np.std(ys,0)
	return [mean,interval_distance], min_length

def read_data_npy_analyse2(paths=[],smoothed=20):
	final_datas = {'x':[],'sr':[],'return':[]}
	min_length = 100000000000
	for p in paths:
		data = np.load(p)
		# value_steps = data['Step'].values
		return_steps = data/100
		value_steps = np.arange(return_steps.shape[0])*10
		x = smooth(value_steps[None], smoothed)[0]
		sr = smooth(return_steps[None], smoothed)[0]
		returns = smooth(return_steps[None], smoothed)[0]
		# srs = smooth(srs, smoothed)
		final_datas['x'].append(x[None])
		final_datas['sr'].append(sr[None])
		final_datas['return'].append(returns[None])
		if x.shape[0]<min_length:
			min_length = x.shape[0]
	for i in range(len(final_datas['x'])):
		final_datas['x'][i] = final_datas['x'][i][:,:min_length]
		final_datas['sr'][i] = final_datas['sr'][i][:, :min_length]
		final_datas['return'][i] = final_datas['return'][i][:, :min_length]
	final_datas['x'] = np.concatenate(final_datas['x'],0) * 500 /1e6
	final_datas['sr'] = np.concatenate(final_datas['sr'], 0)
	final_datas['return'] = np.concatenate(final_datas['return'], 0)
	ys = final_datas['return']
	confidence_interval = stats.bootstrap((ys,), np.mean, axis=1)
	low = confidence_interval.confidence_interval.low
	high = confidence_interval.confidence_interval.high
	# print(low.shape,high.shape,ys.shape)
	mean = np.mean(np.array([low, high]), 0)
	interval_distance = high - mean

	mean = np.mean(ys,0)
	interval_distance = np.std(ys,0)
	return [mean,interval_distance], min_length

def read_data_csv_analyse(paths=[],smoothed=20):
	final_datas = {'x':[],'sr':[],'return':[]}
	min_length = 100000000000
	for p in paths:
		data = pd.read_csv(p)
		# value_steps = data['Step'].values
		return_steps = data['average_normalized_return'].values
		value_steps = np.arange(return_steps.shape[0])*10
		x = smooth(value_steps[None], smoothed)[0]
		sr = smooth(return_steps[None], smoothed)[0]
		returns = smooth(return_steps[None], smoothed)[0]
		# srs = smooth(srs, smoothed)
		final_datas['x'].append(x[None])
		final_datas['sr'].append(sr[None])
		final_datas['return'].append(returns[None])
		if x.shape[0]<min_length:
			min_length = x.shape[0]
	for i in range(len(final_datas['x'])):
		final_datas['x'][i] = final_datas['x'][i][:,:min_length]
		final_datas['sr'][i] = final_datas['sr'][i][:, :min_length]
		final_datas['return'][i] = final_datas['return'][i][:, :min_length]
	final_datas['x'] = np.concatenate(final_datas['x'],0) * 500 /1e6
	final_datas['sr'] = np.concatenate(final_datas['sr'], 0)
	final_datas['return'] = np.concatenate(final_datas['return'], 0)
	ys = final_datas['return']
	# confidence_interval = stats.bootstrap((ys,), np.mean, axis=1)
	# low = confidence_interval.confidence_interval.low
	# high = confidence_interval.confidence_interval.high
	# print(low.shape,high.shape,ys.shape)
	# mean = np.mean(np.array([low, high]), 0)
	# interval_distance = high - mean

	mean = np.mean(ys,0)
	interval_distance = np.std(ys,0)
	# print(ys.shape,mean.shape,mean[-1],paths[0])
	return [mean,interval_distance], min_length

def read_data_csv_analyse3(paths=[],smoothed=20):
	final_datas = {'x':[],'sr':[],'return':[]}
	min_length = 100000000000
	for p in paths:
		data = pd.read_csv(p)
		# value_steps = data['Step'].values
		return_steps = data['normalized return mean'].values
		value_steps = np.arange(return_steps.shape[0])*10
		x = smooth(value_steps[None], smoothed)[0]
		sr = smooth(return_steps[None], smoothed)[0]
		returns = smooth(return_steps[None], smoothed)[0]
		# srs = smooth(srs, smoothed)
		final_datas['x'].append(x[None])
		final_datas['sr'].append(sr[None])
		final_datas['return'].append(returns[None])
		if x.shape[0]<min_length:
			min_length = x.shape[0]
	for i in range(len(final_datas['x'])):
		final_datas['x'][i] = final_datas['x'][i][:,:min_length]
		final_datas['sr'][i] = final_datas['sr'][i][:, :min_length]
		final_datas['return'][i] = final_datas['return'][i][:, :min_length]
	final_datas['x'] = np.concatenate(final_datas['x'],0) * 500 /1e6
	final_datas['sr'] = np.concatenate(final_datas['sr'], 0)
	final_datas['return'] = np.concatenate(final_datas['return'], 0)
	ys = final_datas['return']
	# confidence_interval = stats.bootstrap((ys,), np.mean, axis=1)
	# low = confidence_interval.confidence_interval.low
	# high = confidence_interval.confidence_interval.high
	# print(low.shape,high.shape,ys.shape)
	# mean = np.mean(np.array([low, high]), 0)
	# interval_distance = high - mean

	mean = np.mean(ys,0)
	interval_distance = np.std(ys,0)
	return [mean,interval_distance], min_length

def read_data_csv_analys2e(paths=[],smoothed=30):
	final_datas = {'x':[],'sr':[],'return':[]}
	min_length = 100000000000
	for p in paths:
		data = pd.read_csv(p)
		# value_steps = data['Step'].values
		return_steps = data['Value'].values
		value_steps = np.arange(return_steps.shape[0])*10
		x = smooth(value_steps[None], smoothed)[0]
		sr = smooth(return_steps[None], smoothed)[0]
		returns = smooth(return_steps[None], smoothed)[0]
		# srs = smooth(srs, smoothed)
		final_datas['x'].append(x[None])
		final_datas['sr'].append(sr[None])
		final_datas['return'].append(returns[None])
		if x.shape[0]<min_length:
			min_length = x.shape[0]
	for i in range(len(final_datas['x'])):
		final_datas['x'][i] = final_datas['x'][i][:,:min_length]
		final_datas['sr'][i] = final_datas['sr'][i][:, :min_length]
		final_datas['return'][i] = final_datas['return'][i][:, :min_length]
	final_datas['x'] = np.concatenate(final_datas['x'],0) * 500 /1e6
	final_datas['sr'] = np.concatenate(final_datas['sr'], 0)
	final_datas['return'] = np.concatenate(final_datas['return'], 0)
	ys = final_datas['return']
	confidence_interval = stats.bootstrap((ys,), np.mean, axis=1)
	low = confidence_interval.confidence_interval.low
	high = confidence_interval.confidence_interval.high
	# print(low.shape,high.shape,ys.shape)
	mean = np.mean(np.array([low, high]), 0)
	interval_distance = high - mean
	mean = np.mean(ys,0)
	interval_distance = np.std(ys,0)
	return [mean,interval_distance], min_length

def read_data_csv_avg(paths=[],smoothed=30):
	final_datas = {'x':[],'sr':[],'return':[]}
	min_length = 100000000000
	for p in paths:
		data = pd.read_csv(p)
		value_steps = data['Step'].values
		return_steps = data['Value'].values
		prev_values = return_steps * value_steps
		prev_values_concat = np.concatenate([[0],prev_values])[:-1]
		value_concat = np.concatenate([[0],value_steps])[:-1]
		return_steps = (prev_values - prev_values_concat) / (value_steps-value_concat)
		x = smooth(value_steps[None], smoothed)[0]
		sr = smooth(return_steps[None], smoothed)[0]
		returns = smooth(return_steps[None], smoothed)[0]
		# srs = smooth(srs, smoothed)
		final_datas['x'].append(x[None])
		final_datas['sr'].append(sr[None])
		final_datas['return'].append(returns[None])
		if x.shape[0]<min_length:
			min_length = x.shape[0]
	for i in range(len(final_datas['x'])):
		final_datas['x'][i] = final_datas['x'][i][:,:min_length]
		final_datas['sr'][i] = final_datas['sr'][i][:, :min_length]
		final_datas['return'][i] = final_datas['return'][i][:, :min_length]
	final_datas['x'] = np.concatenate(final_datas['x'],0) * 500
	final_datas['sr'] = np.concatenate(final_datas['sr'], 0)
	final_datas['return'] = np.concatenate(final_datas['return'], 0)
	return final_datas, min_length

def plot_fig(datas,idxs,names,key,title):
	plt.figure(figsize=(8.5,6))
	plt.style.use('seaborn-whitegrid')
	plt.rc('font', family='Times New Roman')
	plt.clf()
	ax = plt.gca()
	frames = []
	f2s = []
	cnt = 0
	for d, c, n in zip(datas, idxs,
						   names):
		for i in range(d['sr'].shape[0]):
			frame = pd.DataFrame(data=d['sr'][i], columns=['Success'], index=np.arange(d['sr'].shape[1]) + cnt)
			cnt += d['sr'].shape[1]
			frame[' '] = [n] * d['sr'].shape[1]
			frame['Million Samples'] = d['x'][0]
			# frame['sr%d'%0]=
			frames.append(frame)
			frame = pd.DataFrame(data=d['return'][i], columns=['Return'], index=np.arange(d['return'].shape[1]) + cnt)
			cnt += d['return'].shape[1]
			frame[' '] = [n] * d['return'].shape[1]
			frame['Million Samples'] = d['x'][0]
			f2s.append(frame)
	f = pd.concat(frames, 0)
	f2 = pd.concat(f2s, 0)

	if key=='Return':
		seaborn.lineplot(x='Million Samples', y="Return",
						 data=f2,
						 hue=' ',
						 legend='full',
						 err_kws={'alpha': 0.1}, linewidth=3)
		plt.ylabel('Return',fontsize=20)
	else:
		seaborn.lineplot(x='Million Samples', y="Success",
						 data=f,
						 hue=' ',
						 legend='full',
						 err_kws={'alpha': 0.1}, linewidth=3)
		plt.ylabel('Success', fontsize=20)
	plt.xlabel('Million Samples',fontsize=20)
	ax.xaxis.label.set_size(20)
	ax.yaxis.label.set_size(20)
	plt.tick_params(labelsize=17)
	plt.title(title,fontdict={'fontsize':30})
	legend()
	plt.tight_layout()
	plt.show()


def plot_fig_save(datas,idxs,names,key,title):
	plt.figure(figsize=(8.5,6))
	plt.style.use('seaborn-whitegrid')
	plt.rc('font', family='Times New Roman')
	plt.clf()
	ax = plt.gca()
	frames = []
	f2s = []
	cnt = 0
	for d, c, n in zip(datas, idxs,
						   names):
		for i in range(d['sr'].shape[0]):
			frame = pd.DataFrame(data=d['sr'][i], columns=['Success'], index=np.arange(d['sr'].shape[1]) + cnt)
			cnt += d['sr'].shape[1]
			frame[' '] = [n] * d['sr'].shape[1]
			frame['Million Samples'] = d['x'][0]
			# frame['sr%d'%0]=
			frames.append(frame)
			frame = pd.DataFrame(data=d['return'][i], columns=['Return'], index=np.arange(d['return'].shape[1]) + cnt)
			cnt += d['return'].shape[1]
			frame[' '] = [n] * d['return'].shape[1]
			frame['Million Samples'] = d['x'][0]
			f2s.append(frame)
	f = pd.concat(frames, 0)
	f2 = pd.concat(f2s, 0)

	if key=='Return':
		seaborn.lineplot(x='Million Samples', y="Return",
						 data=f2,
						 hue=' ',
						 legend='full',
						 err_kws={'alpha': 0.1}, linewidth=3)
		plt.ylabel('Return',fontsize=20)
	else:
		seaborn.lineplot(x='Million Samples', y="Success",
						 data=f,
						 hue=' ',
						 legend='full',
						 err_kws={'alpha': 0.1}, linewidth=3)
		plt.ylabel('Success', fontsize=20)
	plt.xlabel('Million Samples',fontsize=20)
	ax.xaxis.label.set_size(20)
	ax.yaxis.label.set_size(20)
	plt.tick_params(labelsize=17)
	plt.title(title,fontdict={'fontsize':30})
	legend()
	plt.tight_layout()
	plt.savefig('./figures/'+title+'.png')
	# plt.show()