% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CVEQUAL.R
\name{CVEQUAL}
\alias{CVEQUAL}
\title{CVEQUAL where the tuning parameter is chosen by cross-validation}
\usage{
CVEQUAL(X, K = 5, type = TRUE, sdiag = FALSE, lambda = NULL,
  lambda.min = sqrt(log(ncol(X))/nrow(X)), nlambda = 50,
  err = 10^(-5), maxIter = 1000, rho = 1)
}
\arguments{
\item{X}{data matrix of dimension n*p.}

\item{K}{the number of folds. Default is 5.}

\item{type}{Should the loss function be symmetric? Default is TRUE.}

\item{sdiag}{Should diagonal of inverse covariance be penalized? Default is FALSE.}

\item{lambda}{user supplied tuning parameter; Default is NULL and the program compute its own
sequence based on \code{nlambda}.}

\item{lambda.min}{smallest value for lambda, as a fraction of lambda.max which is available when lambda is NULL. 
Default is sqrt(log(p)/n).}

\item{nlambda}{the length of the tuning parameter sequence which is available when lambda is NULL. Default is 50.}

\item{err}{the precision used to stop the convergence. Default is 1e-5. 
Iterations stop when average absolute parameter change is less than \code{err}.}

\item{maxIter}{Maximum number of iterations. Default is 1000.}

\item{rho}{step parameter for the ADMM. Default is 1.}
}
\value{
A list with components
\item{Omega}{the estimated p*p precision matrix.}
\item{cvlambda}{the chosen lambda by cross-validation.}
\item{lambda}{the used lambda list for cross-validation.}
\item{CVloss}{the empirical loss of cross-validation related to lambda.}
}
\description{
CVEQUAL where the tuning parameter is chosen by cross-validation
}
