# 1) 호스트에서 스냅샷 경로를 변수로 지정
MODEL_DIR="/nfs_edlab/jhmoon/medgemma/models--google--medgemma-27b-text-it/snapshots/6b08c481126ff65a9b8fa5ab4d691b152b8edb5d"
# MODEL_DIR="/home/edlab/jhmoon/medgemma/models--google--medgemma-27b-text-it/snapshots/6b08c481126ff65a9b8fa5ab4d691b152b8edb5d"

# 2) 필수 파일이 있는지 확인 (config.json 있어야 함)
ls -l "$MODEL_DIR/config.json"

# 3) 재실행
docker rm -f vllm-medgemma 2>/dev/null || true

docker run -d \
  --name vllm-medgemma \
  --gpus all \
  --ipc=host \
  -p 8002:8000 \
  --user "$(id -u)":"$(id -g)" \
  -e USER=jhmoon \
  -e HOME=/tmp \
  -e CUDA_VISIBLE_DEVICES=2,3 \
  -e HF_HUB_OFFLINE=1 \
  -e TRANSFORMERS_OFFLINE=1 \
  -v "$MODEL_DIR":/model:ro \
  vllm/vllm-openai:gptoss \
    --model /model \
    --served-model-name medgemma-27b-text-it \
    --tensor-parallel-size 2 \
    --gpu-memory-utilization 0.90