import pandas as pd
import random
import os

# Receive k,n,p,q as parameters and generate random graphs using SBM

# k: the number of clusters
# n: |C_i|
# p: probability that any pair of vertices within each cluster is connected by an edge
# q: probability that any pair of vertices from different clusters is connected by an edge

# V = {0, 1, 2, ..., kn-1}
# C_i = {x: (i-1)n ≤ x ≤ in-1}, 1 ≤ i ≤ k




def SBM(n, k, p, q):
    data_path = "./SyntheticData/" + "n=" + str(n) + "_k=" + str(k) + "_p=" + str(p) + "_q=" + str(q) + ".csv"
    if os.path.exists(data_path):
        print('Random graph with the following parameters already exists:')
        print(f'\tn: {n}, k: {k}')
        print(f'\tp: {p} , q: {q}\n')
    else:
        print('Creating a random graph with the following parameters:')
        print(f'\tn: {n}, k: {k}')
        print(f'\tp: {p} , q: {q}\n')

        N = n * k  # N = |V|

        node1 = []
        node2 = []
        for i in range(0, N):
            for j in range(i + 1, N):
                temp = random.random()

                if int(j / n) == int(i / n):  # i, j are in the same cluster
                    if temp <= p:  # w.p. p
                        node1.append(i)
                        node2.append(j)
                else:  # i, j are in the different clusters
                    if temp <= q:  # w.p. q
                        node1.append(i)
                        node2.append(j)

        temp = {'node1': node1, 'node2': node2}
        E = pd.DataFrame(temp)  # edges

        E.to_csv(data_path, index=False)
        print("done generate the graph")

# n = 1000
# k = 3
# q = 0.002
# p_list = [0.02, 0.0225, 0.025, 0.0275, 0.03, 0.04, 0.05, 0.06, 0.07]
# for p in p_list:
#     SBM(n, k, p, q)