# DetectBench
##  1. Introduction  
Pytorch based implementation of Domain Generalization algorithms based on faster rcnn framework.
##  2. Prerequisites
* Python 2.7 or 3.5  
* Pytorch 1.5.1  
* torchvision 0.6.1  
* numpy 1.15.4
* Pillow 6.1.0
* pycocotools 2.0
* matplotlib 3.0.2
* tensorboardX 2.0  
```Shell
pip install -r requirements.txt
  ```
##  3. Data Preparation
```
Data dir should like this, for example BDD100K-Weather:
```
    data_root
        |-- img_root
                |-- [xxxxxxxxxxxx].jpg
                |-- [xxxxxxxxxxxx].jpg
                |-- [xxxxxxxxxxxx].jpg
                |-- [xxxxxxxxxxxx].jpg
        |-- clear.json
        |-- overcast.json
        |-- instances_test.json


##  4. Train
#### 4.1 Key arguments
Some Key arguments, modify them in config/train_config.py:  
`--backbone`: feature extraction backbone network  
`--algorithm`: The algorithm to use  
`--pretrained_weights`: path to the pretrained weights  
`--num_class`: number of classification, including background  
`--data_root`: dataset root  
`--img_root`: image root, containing all the images  
`--test_anno`: testing annotation file, for example `data_root/instances_test.json`   
`--train_domain`: training domains, for example `['clear','overcast']`   
#### 4.2 Begin to train
```Shell
python -m torch.distributed.launch --nproc_per_node=1 train.py
  ```