

class Config:
    backbone = 'resnet50_fpn'  # [vgg16, resnet-fpn, mobilenet, resnet50_fpn]
    algorithm = "IRM"

    # data transform parameter
    train_horizon_flip_prob = 0.  # data horizon flip probility in train transform
    min_size = 800
    max_size = 1333
    image_mean = [0.485, 0.456, 0.406]
    image_std = [0.229, 0.224, 0.225]

    # anchor parameters
    anchor_size = (32, 64, 128, 256, 512)
    anchor_ratio = ((0.5, 1, 2.0),)

    # roi align parameters
    roi_out_size = [7, 7]
    roi_sample_rate = 0

    # rpn process parameters
    rpn_pre_nms_top_n_train = 2000
    rpn_post_nms_top_n_train = 2000

    rpn_pre_nms_top_n_test = 1000
    rpn_post_nms_top_n_test = 1000

    rpn_nms_thresh = 0.7
    rpn_fg_iou_thresh = 0.7
    rpn_bg_iou_thresh = 0.3
    rpn_batch_size_per_image = 256
    rpn_positive_fraction = 0.5

    # remove low threshold target
    box_score_thresh = 0.05
    box_nms_thresh = 0.5
    box_detections_per_img = 100
    box_fg_iou_thresh = 0.5
    box_bg_iou_thresh = 0.5
    box_batch_size_per_image = 512
    box_positive_fraction = 0.25
    bbox_reg_weights = None

    device_name = 'cuda'

    resume = ''  # pretrained_weights
    start_epoch = 0  # start epoch
    num_epochs = 50  # train epochs

    # learning rate parameters
    lr = 2e-2
    momentum = 0.9
    weight_decay = 0.0005

    # learning rate schedule
    lr_gamma = 0.33
    lr_dec_step_size = 100

    pretrained_weights = 'dh_faster_rcnn_r50_fpn_1x_coco_20200130-586b67df.pth'
    num_class = 1 + 1  # foreground + 1 background
    data_root = ""
    img_root = ""
    test_anno = ""
    model_save_dir = ""
    train_domain = ['clear_sample', 'overcast_sample']

    mini_batch_size = 12
    batch_size = mini_batch_size * len(train_domain)
    num_workers = 0


cfg = Config()
