import time
import torch
import torch.distributed as dist
import numpy as np
from utils.train_utils import MetricLogger
from utils.coco_utils import get_coco_api_from_dataset, CocoEvaluator, object_detection_evaluate


@torch.no_grad()
def evaluate(model, data_loader, device, mAP_list=None, domain=None):
    n_threads = torch.get_num_threads()
    cpu_device = torch.device("cpu")
    model.eval()
    metric_logger = MetricLogger(delimiter="  ")
    header = "Test: "

    coco = get_coco_api_from_dataset(data_loader.dataset)
    iou_types = ["bbox"]
    coco_evaluator = CocoEvaluator(coco, iou_types)

    predict_list = list()
    target_list = list()
    
    for image, targets in metric_logger.log_every(data_loader, 100, header):        
        image = list(img.to(device) for img in image)
        outputs = model(image)
        outputs = [{k: v.to(cpu_device) for k, v in t.items()} for t in outputs]
#         model_time = time.time() - model_time

        for target, output in zip(targets, outputs):
            target_list.append(np.array([[l]+b for b, l in zip(target['boxes'].tolist(), target['labels'].tolist())]))
            predict_list.append(np.array([b+[s, l] for b, s, l in zip(output['boxes'].tolist(), output['scores'].tolist(), output['labels'].tolist())]))

    print(len(target_list))
    print(len(predict_list))
    
    coco_stats = object_detection_evaluate(target_list, predict_list, domain)
    return coco_stats, coco_stats[0]
