#! /usr/bin/env python3
# -*- coding: utf-8 -*-
# File   : get_sweep_results_and_plot.py
# Author : Anonymous1
# Email  : anonymous1@anon
#
# Distributed under terms of the MIT license.

"""
Usage: python3 scripts/get_sweep_results_and_plot.py dumps/{EXP_NAME}
    -exg='{EXTRA ARGS for get_best_hps.py}'
    -exp='{EXTRA ARGS for read_and_plot_results.py}'
"""

import os
import os.path as osp
import argparse

parser = argparse.ArgumentParser()

parser.add_argument("dumpdir", type=str, help="The dump dir for sweeping params")
parser.add_argument(
    "--script-dir",
    "-script",
    type=str,
    default="scripts",
    help="The script dir",
)
parser.add_argument(
    "--cfg-dir",
    "-cfg",
    type=str,
    default="bash",
    help="The cfg dir",
)
parser.add_argument(
    "--smaller-better",
    "-sb",
    action="store_true",
    help="Smaller is better",
)
parser.add_argument(
    "--extra-plot",
    "-exp",
    type=str,
    default="",
    help="The extra cmd for read_and_plot_results.py, use explicit = to get the value",
)
parser.add_argument(
    "--extra-get",
    "-exg",
    type=str,
    default="",
    help="The extra cmd for get_best_hps.py, use explicit = to get the value",
)
args = parser.parse_args()


def main():
    exp_name = osp.basename(args.dumpdir)
    cfg_file = osp.join(
        osp.join(args.script_dir, args.cfg_dir), f"{exp_name}_config.py"
    )
    if not osp.exists(cfg_file):
        print(f"{cfg_file} not found")
        return
    print(f"Get {exp_name} results with config file: {cfg_file}")
    os.system(f"cat {cfg_file}")

    # read_and_plot_results
    read_and_plot_results = osp.join(args.script_dir, "read_and_plot_results.py")
    dump_dirs = osp.join(args.dumpdir, "*")
    plot_cmd = f"python3 {read_and_plot_results} {dump_dirs} -pl -silence"
    if args.smaller_better:
        plot_cmd += " -sb"
    plot_cmd += f" {args.extra_plot}"
    print(f"[get_sweep_results_and_plot.py] Executing {plot_cmd}")
    os.system(plot_cmd)

    # get_best_hps
    get_best_hps = osp.join(args.script_dir, "get_best_hps.py")
    get_cmd = f"python3 {get_best_hps} {cfg_file} -du {args.dumpdir}"
    if args.smaller_better:
        get_cmd += " -sb"
    get_cmd += f" {args.extra_get}"
    print(f"[get_sweep_results_and_plot.py] Executing {get_cmd}")
    os.system(get_cmd)


if __name__ == "__main__":
    main()
