import sys
import os
import numpy as np

class Parameter():
    def __init__(self, partial_run={}):
        self.param = {
                        'algo': ['main', 'baseline'],
                        'type': ['sparse', 'dense'],
                        'action_space': [5, 10],
                        'num_players': [2 ** _ for _ in range(3, 13)],
                        'prob': [1, 3, 5],
                        'out_num': [1000],
                        'seed': [_ for _ in range(10)],
                      }
        self.mask_list = [
                            ['type', ['sparse'], 'num_players', [2 ** _ for _ in range(5, 17)]]
                        ]

        self.param_list = []
        self.Set_Param(0, {})

        self.n = len(self.param_list)
        self.active_idx = []
        for i in range(self.n):
            flag = True
            for k in partial_run:
                if self.param_list[i][k] not in partial_run[k]:
                    flag = False
                    break
            if flag:
                self.active_idx.append(i)
        self.n = len(self.active_idx)
        print(self.n)

    def Set_Param(self, k, param):
        if k == len(list(self.param.keys())):
            self.param_list.append(param.copy())
            return
        
        name = list(self.param.keys())[k]
        param_list = self.param[name]

        if name in param.keys():
            self.Set_Param(k+1, param)
            return

        for mask in self.mask_list:
            if mask[0] in param.keys() and param[mask[0]] in mask[1] and name == mask[2]:
                param_list = mask[3]
            if mask[0] in param.keys() and param[mask[0]] in mask[1] and mask[2] in param.keys() and param[mask[2]] not in mask[3]:
                return
        for v in param_list:
            param[name] = v
            self.Set_Param(k+1, param)
        del param[name]

    def get_param(self, idx):
        if type(idx) == int:
            return self.param_list[self.active_idx[idx]]
        elif type(idx) == dict:
            param_idx_list = []
            for i in range(self.n):
                flag = True
                for k, v in idx.items():
                    if self.param_list[i][k] != v:
                        flag = False
                        break
                if flag:
                    param_idx_list.append(i)
            return np.array(param_idx_list)
    

if __name__ == '__main__':
    idx_start = int(sys.argv[1])
    current_dir = os.getcwd()
    param = Parameter()
    print(param.n)

    os.makedirs(current_dir + '/result', exist_ok=True)
    
    for idx in range(idx_start, param.n, int(sys.argv[2])):
        if os.path.exists(current_dir + '/result/' + str(param.active_idx[idx]) + '.json'):
            continue
        param_str = ' '
        x = param.get_param(idx)
        x['prob'] = x['prob'] / x['num_players'] if x['type'] == 'sparse' else x['prob'] / 10
        del x['type']
        algo = x.pop('algo')
        for k, v in x.items():
            if type(v) == bool:
                if v:
                    param_str += f'--{k} '
            else:
                param_str += f'--{k} {v} '

        if algo == "main":
            command_line = f'python {current_dir}/main.py ' + param_str + f' --json {current_dir}/result/' + str(param.active_idx[idx]) + '.json'
        if algo == "baseline":
            command_line = f'python {current_dir}/baseline.py ' + param_str + f' --json {current_dir}/result/' + str(param.active_idx[idx]) + '.json'
        command_line = f"CUDA_VISIBLE_DEVICES={idx_start} " + command_line
        print(command_line)
        
        os.system(command_line)